/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.builder;

import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementAssignable;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.builder.impl.ArrayBuilderImpl;
import com.allanbank.mongodb.bson.builder.impl.DocumentBuilderImpl;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class BuilderFactory {
    public static final ArrayElement a() throws IllegalArgumentException {
        return new ArrayElement("", new Element[0]);
    }

    public static final ArrayElement a(Boolean ... booleanArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Boolean bl : booleanArray) {
            if (bl != null) {
                arrayBuilder.add(bl);
                continue;
            }
            arrayBuilder.addNull();
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(byte[] ... byArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (byte[] byArray2 : byArray) {
            arrayBuilder.add((Object)byArray2);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(Date ... dateArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Date date : dateArray) {
            arrayBuilder.add((Object)date);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(DocumentAssignable ... documentAssignableArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            arrayBuilder.add((Object)documentAssignable);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(Double ... doubleArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Double d : doubleArray) {
            if (d != null) {
                arrayBuilder.add(d);
                continue;
            }
            arrayBuilder.addNull();
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(ElementAssignable ... elementAssignableArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (ElementAssignable elementAssignable : elementAssignableArray) {
            arrayBuilder.add((Object)elementAssignable);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(Integer ... integerArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Integer n : integerArray) {
            if (n != null) {
                arrayBuilder.add(n);
                continue;
            }
            arrayBuilder.addNull();
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(Long ... longArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Long l : longArray) {
            if (l != null) {
                arrayBuilder.add(l);
                continue;
            }
            arrayBuilder.addNull();
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(Object ... objectArray) {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Object object : objectArray) {
            arrayBuilder.add(object);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(ObjectId ... objectIdArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (ObjectId objectId : objectIdArray) {
            arrayBuilder.add((Object)objectId);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(Pattern ... patternArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (Pattern pattern : patternArray) {
            arrayBuilder.add((Object)pattern);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(String ... stringArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (String string : stringArray) {
            arrayBuilder.add((Object)string);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final ArrayElement a(UUID ... uUIDArray) throws IllegalArgumentException {
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        for (UUID uUID : uUIDArray) {
            arrayBuilder.add((Object)uUID);
        }
        return new ArrayElement("", arrayBuilder.build());
    }

    public static final DocumentBuilder d(Element ... elementArray) {
        return new DocumentBuilderImpl(new RootDocument(elementArray));
    }

    public static final BooleanElement e(String string, boolean bl) throws IllegalArgumentException {
        return new BooleanElement(string, bl);
    }

    public static final Element e(String string, byte[] byArray) throws IllegalArgumentException {
        if (byArray != null) {
            return new BinaryElement(string, byArray);
        }
        return new NullElement(string);
    }

    public static final Element e(String string, Date date) throws IllegalArgumentException {
        if (date != null) {
            return new TimestampElement(string, date.getTime());
        }
        return new NullElement(string);
    }

    public static final Element e(String string, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        if (documentAssignable != null) {
            return new DocumentElement(string, documentAssignable.asDocument());
        }
        return new NullElement(string);
    }

    public static final DoubleElement e(String string, double d) throws IllegalArgumentException {
        return new DoubleElement(string, d);
    }

    public static final Element e(String string, ElementAssignable elementAssignable) throws IllegalArgumentException {
        if (elementAssignable != null) {
            return elementAssignable.asElement().withName(string);
        }
        return new NullElement(string);
    }

    public static final IntegerElement e(String string, int n) throws IllegalArgumentException {
        return new IntegerElement(string, n);
    }

    public static final LongElement e(String string, long l) throws IllegalArgumentException {
        return new LongElement(string, l);
    }

    public static final Element e(String string, Object object) {
        if (object == null) {
            return new NullElement(string);
        }
        if (object instanceof Boolean) {
            return new BooleanElement(string, (Boolean)object);
        }
        if (object instanceof Long || object instanceof BigInteger) {
            return new LongElement(string, ((Number)object).longValue());
        }
        if (object instanceof Double || object instanceof Float) {
            return new DoubleElement(string, ((Number)object).doubleValue());
        }
        if (object instanceof Number) {
            return new IntegerElement(string, ((Number)object).intValue());
        }
        if (object instanceof byte[]) {
            return new BinaryElement(string, (byte[])object);
        }
        if (object instanceof ObjectId) {
            return new ObjectIdElement(string, (ObjectId)object);
        }
        if (object instanceof Pattern) {
            return new RegularExpressionElement(string, (Pattern)object);
        }
        if (object instanceof String) {
            return new StringElement(string, (String)object);
        }
        if (object instanceof Date) {
            return new TimestampElement(string, ((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new TimestampElement(string, ((Calendar)object).getTime().getTime());
        }
        if (object instanceof UUID) {
            return new UuidElement(string, (UUID)object);
        }
        if (object instanceof DocumentAssignable) {
            return new DocumentElement(string, ((DocumentAssignable)object).asDocument());
        }
        if (object instanceof ElementAssignable) {
            return ((ElementAssignable)object).asElement().withName(string);
        }
        if (object instanceof Map) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                documentBuilder.add(entry.getKey().toString(), entry.getValue());
            }
            return new DocumentElement(string, documentBuilder.build());
        }
        if (object instanceof Collection) {
            ArrayBuilder arrayBuilder = BuilderFactory.startArray();
            for (Object e : (Collection)object) {
                arrayBuilder.add(e);
            }
            return new ArrayElement(string, arrayBuilder.build());
        }
        if (object instanceof Object[]) {
            ArrayBuilder arrayBuilder = BuilderFactory.startArray();
            for (Object object2 : (Object[])object) {
                arrayBuilder.add(object2);
            }
            return new ArrayElement(string, arrayBuilder.build());
        }
        throw new IllegalArgumentException("Could not coerce the type '" + object.getClass().getName() + "' into a valid BSON element type.");
    }

    public static final Element e(String string, ObjectId objectId) throws IllegalArgumentException {
        if (objectId != null) {
            return new ObjectIdElement(string, objectId);
        }
        return new NullElement(string);
    }

    public static final Element e(String string, Pattern pattern) throws IllegalArgumentException {
        if (pattern != null) {
            return new RegularExpressionElement(string, pattern);
        }
        return new NullElement(string);
    }

    public static final Element e(String string, String string2) throws IllegalArgumentException {
        if (string2 != null) {
            return new StringElement(string, string2);
        }
        return new NullElement(string);
    }

    public static final Element e(String string, UUID uUID) throws IllegalArgumentException {
        if (uUID != null) {
            return new UuidElement(string, 4, uUID);
        }
        return new NullElement(string);
    }

    public static final DocumentBuilder start() {
        return new DocumentBuilderImpl();
    }

    public static final DocumentBuilder start(DocumentAssignable documentAssignable) {
        return new DocumentBuilderImpl(documentAssignable);
    }

    public static final DocumentBuilder start(DocumentAssignable ... documentAssignableArray) {
        DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl();
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            for (Element element : documentAssignable.asDocument()) {
                documentBuilderImpl.remove(element.getName());
                documentBuilderImpl.add(element);
            }
        }
        return documentBuilderImpl;
    }

    public static final ArrayBuilder startArray() {
        return new ArrayBuilderImpl();
    }

    private BuilderFactory() {
    }
}

