/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.builder.impl;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.Builder;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.builder.impl.ArrayBuilderImpl;
import com.allanbank.mongodb.bson.builder.impl.DocumentBuilderImpl;
import com.allanbank.mongodb.bson.element.AbstractElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractBuilder
implements Builder {
    protected static final boolean ASSERTIONS_ENABLED;
    protected static final Class<BuilderElement> BUILDER_ELEMENT_CLASS;
    protected final List<Element> myElements;
    protected long mySize;
    private final AbstractBuilder myOuterBuilder;

    public AbstractBuilder(AbstractBuilder abstractBuilder) {
        this.myOuterBuilder = abstractBuilder;
        this.myElements = new ArrayList<Element>(32);
        this.mySize = 0L;
    }

    @Override
    public Builder pop() {
        return this.myOuterBuilder;
    }

    @Override
    public Builder reset() {
        this.myElements.clear();
        return this;
    }

    protected abstract Element build(String var1);

    protected DocumentBuilder doPush(String string) {
        DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl(this);
        this.myElements.add(new BuilderElement(string, documentBuilderImpl));
        return documentBuilderImpl;
    }

    protected ArrayBuilder doPushArray(String string) {
        ArrayBuilderImpl arrayBuilderImpl = new ArrayBuilderImpl(this);
        this.myElements.add(new BuilderElement(string, arrayBuilderImpl));
        return arrayBuilderImpl;
    }

    protected List<Element> subElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>(this.myElements.size());
        HashSet<String> hashSet = null;
        for (Element element : this.myElements) {
            if (element.getClass() == BUILDER_ELEMENT_CLASS) {
                element = ((BuilderElement)element).build();
            }
            if (ASSERTIONS_ENABLED) {
                String string;
                if (hashSet == null) {
                    hashSet = new HashSet<String>(this.myElements.size() << 1);
                }
                if (!hashSet.add(string = element.getName())) assert (false) : string + " is not unique in  " + this.myElements;
            }
            arrayList.add(element);
        }
        return arrayList;
    }

    static {
        BUILDER_ELEMENT_CLASS = BuilderElement.class;
        ASSERTIONS_ENABLED = AbstractBuilder.class.desiredAssertionStatus();
    }

    public static final class BuilderElement
    extends AbstractElement {
        private static final long serialVersionUID = 4421203621373216989L;
        private transient AbstractBuilder myBuilder;

        public BuilderElement(String string, AbstractBuilder abstractBuilder) {
            super(string, 0L);
            this.myBuilder = abstractBuilder;
        }

        @Override
        public void accept(Visitor visitor) {
            this.build().accept(visitor);
        }

        public Element build() {
            return this.myBuilder.build(this.getName());
        }

        @Override
        public ElementType getType() {
            return null;
        }

        @Override
        public Object getValueAsObject() {
            return null;
        }

        @Override
        public BuilderElement withName(String string) {
            return new BuilderElement(string, this.myBuilder);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.myBuilder = null;
        }
    }
}

