/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.builder.impl;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementAssignable;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.builder.impl.AbstractBuilder;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DBPointerElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.bson.element.JavaScriptWithScopeElement;
import com.allanbank.mongodb.bson.element.JsonSerializationVisitor;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.MaxKeyElement;
import com.allanbank.mongodb.bson.element.MinKeyElement;
import com.allanbank.mongodb.bson.element.MongoTimestampElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;

public class DocumentBuilderImpl
extends AbstractBuilder
implements DocumentBuilder {
    private boolean myIdPresent;

    public DocumentBuilderImpl() {
        this((AbstractBuilder)null);
    }

    public DocumentBuilderImpl(AbstractBuilder abstractBuilder) {
        super(abstractBuilder);
    }

    public DocumentBuilderImpl(DocumentAssignable documentAssignable) {
        this((AbstractBuilder)null);
        Document document = documentAssignable.asDocument();
        this.myElements.addAll(document.getElements());
    }

    @Override
    public DocumentBuilder add(ElementAssignable elementAssignable) throws IllegalArgumentException {
        Element element = elementAssignable.asElement();
        this.myElements.add(element);
        if ("_id".equals(element.getName())) {
            this.myIdPresent = true;
        }
        return this;
    }

    @Override
    public DocumentBuilder add(String string, boolean bl) throws IllegalArgumentException {
        return this.addBoolean(string, bl);
    }

    @Override
    public DocumentBuilder add(String string, byte by, byte[] byArray) throws IllegalArgumentException {
        return this.addBinary(string, by, byArray);
    }

    @Override
    public DocumentBuilder add(String string, byte[] byArray) throws IllegalArgumentException {
        if (byArray == null) {
            return this.addNull(string);
        }
        return this.addBinary(string, byArray);
    }

    @Override
    public DocumentBuilder add(String string, Date date) throws IllegalArgumentException {
        if (date == null) {
            return this.addNull(string);
        }
        return this.addTimestamp(string, date.getTime());
    }

    @Override
    public DocumentBuilder add(String string, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        if (documentAssignable == null) {
            return this.addNull(string);
        }
        return this.addDocument(string, documentAssignable);
    }

    @Override
    public DocumentBuilder add(String string, double d) throws IllegalArgumentException {
        return this.addDouble(string, d);
    }

    @Override
    public DocumentBuilder add(String string, int n) throws IllegalArgumentException {
        return this.addInteger(string, n);
    }

    @Override
    public DocumentBuilder add(String string, long l) throws IllegalArgumentException {
        return this.addLong(string, l);
    }

    @Override
    public DocumentBuilder add(String string, Object object) throws IllegalArgumentException {
        this.add(BuilderFactory.e(string, object));
        return this;
    }

    @Override
    public DocumentBuilder add(String string, ObjectId objectId) throws IllegalArgumentException {
        if (objectId == null) {
            return this.addNull(string);
        }
        return this.addObjectId(string, objectId);
    }

    @Override
    public DocumentBuilder add(String string, Pattern pattern) throws IllegalArgumentException {
        if (pattern == null) {
            return this.addNull(string);
        }
        return this.addRegularExpression(string, pattern);
    }

    @Override
    public DocumentBuilder add(String string, String string2) throws IllegalArgumentException {
        if (string2 == null) {
            return this.addNull(string);
        }
        return this.addString(string, string2);
    }

    @Override
    @Deprecated
    public DocumentBuilder add(String string, String string2, String string3, ObjectId objectId) throws IllegalArgumentException {
        return this.addDBPointer(string, string2, string3, objectId);
    }

    @Override
    public DocumentBuilder add(String string, UUID uUID) throws IllegalArgumentException {
        if (uUID == null) {
            return this.addNull(string);
        }
        return this.addUuid(string, uUID);
    }

    @Override
    public DocumentBuilder addBinary(String string, byte by, byte[] byArray) throws IllegalArgumentException {
        return this.add(new BinaryElement(string, by, byArray));
    }

    @Override
    public DocumentBuilder addBinary(String string, byte[] byArray) throws IllegalArgumentException {
        return this.add(new BinaryElement(string, byArray));
    }

    @Override
    public DocumentBuilder addBoolean(String string, boolean bl) throws IllegalArgumentException {
        return this.add(new BooleanElement(string, bl));
    }

    @Override
    @Deprecated
    public DocumentBuilder addDBPointer(String string, String string2, String string3, ObjectId objectId) throws IllegalArgumentException {
        return this.add(new DBPointerElement(string, string2, string3, objectId));
    }

    @Override
    public DocumentBuilder addDocument(String string, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.add(new DocumentElement(string, documentAssignable.asDocument()));
    }

    @Override
    public DocumentBuilder addDouble(String string, double d) throws IllegalArgumentException {
        return this.add(new DoubleElement(string, d));
    }

    @Override
    public DocumentBuilder addInteger(String string, int n) throws IllegalArgumentException {
        return this.add(new IntegerElement(string, n));
    }

    @Override
    public DocumentBuilder addJavaScript(String string, String string2) throws IllegalArgumentException {
        return this.add(new JavaScriptElement(string, string2));
    }

    @Override
    public DocumentBuilder addJavaScript(String string, String string2, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.add(new JavaScriptWithScopeElement(string, string2, documentAssignable.asDocument()));
    }

    @Override
    public DocumentBuilder addLegacyUuid(String string, UUID uUID) throws IllegalArgumentException {
        return this.add(new UuidElement(string, 3, uUID));
    }

    @Override
    public DocumentBuilder addLong(String string, long l) throws IllegalArgumentException {
        return this.add(new LongElement(string, l));
    }

    @Override
    public DocumentBuilder addMaxKey(String string) throws IllegalArgumentException {
        return this.add(new MaxKeyElement(string));
    }

    @Override
    public DocumentBuilder addMinKey(String string) throws IllegalArgumentException {
        return this.add(new MinKeyElement(string));
    }

    @Override
    public DocumentBuilder addMongoTimestamp(String string, long l) throws IllegalArgumentException {
        return this.add(new MongoTimestampElement(string, l));
    }

    @Override
    public DocumentBuilder addNull(String string) throws IllegalArgumentException {
        return this.add(new NullElement(string));
    }

    @Override
    public DocumentBuilder addObjectId(String string, ObjectId objectId) throws IllegalArgumentException {
        return this.add(new ObjectIdElement(string, objectId));
    }

    @Override
    public DocumentBuilder addRegularExpression(String string, Pattern pattern) throws IllegalArgumentException {
        return this.add(new RegularExpressionElement(string, pattern));
    }

    @Override
    public DocumentBuilder addRegularExpression(String string, String string2, String string3) throws IllegalArgumentException {
        return this.add(new RegularExpressionElement(string, string2, string3));
    }

    @Override
    public DocumentBuilder addString(String string, String string2) throws IllegalArgumentException {
        return this.add(new StringElement(string, string2));
    }

    @Override
    public DocumentBuilder addSymbol(String string, String string2) throws IllegalArgumentException {
        return this.add(new SymbolElement(string, string2));
    }

    @Override
    public DocumentBuilder addTimestamp(String string, long l) throws IllegalArgumentException {
        return this.add(new TimestampElement(string, l));
    }

    @Override
    public DocumentBuilder addUuid(String string, UUID uUID) throws IllegalArgumentException {
        return this.add(new UuidElement(string, 4, uUID));
    }

    @Override
    public Document asDocument() {
        return this.build();
    }

    @Override
    public Document build() {
        return new RootDocument(this.subElements(), this.myIdPresent);
    }

    @Override
    public DocumentBuilder push(String string) {
        return this.doPush(string);
    }

    @Override
    public ArrayBuilder pushArray(String string) {
        return this.doPushArray(string);
    }

    @Override
    public DocumentBuilder remove(String string) {
        Iterator iterator = this.myElements.iterator();
        while (iterator.hasNext()) {
            if (!string.equals(((Element)iterator.next()).getName())) continue;
            iterator.remove();
        }
        return this;
    }

    @Override
    public DocumentBuilder reset() {
        super.reset();
        return this;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(stringWriter, false);
        jsonSerializationVisitor.visit(this.myElements);
        return stringWriter.toString();
    }

    @Override
    protected Element build(String string) {
        return new DocumentElement(string, this.subElements(), true);
    }
}

