/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.JsonSerializationVisitor;
import com.allanbank.mongodb.util.Assertions;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;

public abstract class AbstractElement
implements Element {
    protected static final Class<Element> ELEMENT_TYPE = Element.class;
    private static final long serialVersionUID = 7537761445549731633L;
    private final String myName;
    private final long mySize;

    static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public AbstractElement(String string, long l) throws IllegalArgumentException {
        Assertions.assertNotNull(string, "Cannot have an null name on an element.");
        this.myName = string;
        this.mySize = l;
    }

    @Override
    public Element asElement() {
        return this;
    }

    @Override
    public int compareTo(Element element) {
        int n = this.myName.compareTo(element.getName());
        if (n == 0) {
            n = this.getType().compare(element.getType());
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            AbstractElement abstractElement = (AbstractElement)object;
            bl = this.nullSafeEquals(this.myName, abstractElement.myName);
        }
        return bl;
    }

    @Override
    public <E extends Element> List<E> find(Class<E> clazz, String ... stringArray) {
        if (stringArray.length == 0 && clazz.isAssignableFrom(this.getClass())) {
            return Collections.singletonList(clazz.cast(this));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Element> find(String ... stringArray) {
        return this.find(ELEMENT_TYPE, stringArray);
    }

    @Override
    public <E extends Element> E findFirst(Class<E> clazz, String ... stringArray) {
        if (stringArray.length == 0 && clazz.isAssignableFrom(this.getClass())) {
            return (E)((Element)clazz.cast(this));
        }
        return null;
    }

    @Override
    public Element findFirst(String ... stringArray) {
        return this.findFirst(ELEMENT_TYPE, stringArray);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getValueAsString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(stringWriter, false);
        jsonSerializationVisitor.setSuppressNames(true);
        this.accept(jsonSerializationVisitor);
        return stringWriter.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.myName == null ? 0 : this.myName.hashCode());
        return n;
    }

    @Override
    public long size() {
        return this.mySize;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(stringWriter, false);
        this.accept(jsonSerializationVisitor);
        return stringWriter.toString();
    }

    protected boolean nullSafeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }
}

