/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.DocumentReference;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.element.SizeAwareVisitor;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;
import com.allanbank.mongodb.util.PatternUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DocumentElement
extends AbstractElement
implements Document {
    public static final List<Element> EMPTY_ELEMENTS = Collections.emptyList();
    public static final ElementType TYPE = ElementType.DOCUMENT;
    private static final long serialVersionUID = -564259598403040796L;
    private Map<String, Element> myElementMap;
    private final List<Element> myElements;

    private static long computeSize(String string, Collection<Element> collection) {
        long l = 7L;
        l += (long)StringEncoder.utf8Size(string);
        if (collection != null && !collection.isEmpty()) {
            for (Element element : collection) {
                l += element.size();
            }
        }
        return l;
    }

    private static long computeSize(String string, long l) {
        long l2 = 2L;
        l2 += (long)StringEncoder.utf8Size(string);
        return l2 += l;
    }

    public DocumentElement(String string, Collection<Element> collection) {
        this(string, (List<Element>)(collection != null ? new ArrayList<Element>(collection) : EMPTY_ELEMENTS), true);
    }

    public DocumentElement(String string, Document document) {
        this(string, document == null ? EMPTY_ELEMENTS : document.getElements(), true, DocumentElement.computeSize(string, document == null ? 5L : document.size()));
        Assertions.assertNotNull(document, "Document element's sub-document cannot be null.");
    }

    public DocumentElement(String string, DocumentElement documentElement) {
        this(string, documentElement != null ? Collections.singletonList(documentElement) : EMPTY_ELEMENTS, true);
        Assertions.assertNotNull(documentElement, "Document element's sub-document cannot be null.");
    }

    public DocumentElement(String string, Element ... elementArray) {
        this(string, Arrays.asList(elementArray));
    }

    public DocumentElement(String string, List<Element> list) {
        this(string, list, false);
    }

    public DocumentElement(String string, List<Element> list, boolean bl) {
        this(string, list, bl, DocumentElement.computeSize(string, list));
    }

    public DocumentElement(String string, List<Element> list, boolean bl, long l) {
        super(string, l);
        this.myElements = list != null && !list.isEmpty() ? (bl ? Collections.unmodifiableList(list) : Collections.unmodifiableList(new ArrayList<Element>(list))) : EMPTY_ELEMENTS;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor instanceof SizeAwareVisitor) {
            ((SizeAwareVisitor)visitor).visitDocument(this.getName(), this.getElements(), this.size());
        } else {
            visitor.visitDocument(this.getName(), this.getElements());
        }
    }

    @Override
    public Document asDocument() {
        return this;
    }

    public DocumentReference asDocumentReference() {
        int n = this.myElements.size();
        if (n == 2) {
            Element element = this.myElements.get(0);
            Element element2 = this.myElements.get(1);
            String string = element.getName();
            ElementType elementType = element.getType();
            String string2 = element2.getName();
            if ("$ref".equals(string) && "$id".equals(string2)) {
                if (elementType == ElementType.STRING) {
                    return new DocumentReference(((StringElement)element).getValue(), element2);
                }
                if (elementType == ElementType.SYMBOL) {
                    return new DocumentReference(((SymbolElement)element).getSymbol(), element2);
                }
            }
        } else if (this.myElements.size() == 3) {
            Element element = this.myElements.get(0);
            Element element3 = this.myElements.get(1);
            Element element4 = this.myElements.get(2);
            String string = element.getName();
            ElementType elementType = element.getType();
            String string3 = element3.getName();
            String string4 = element4.getName();
            ElementType elementType2 = element4.getType();
            if ("$ref".equals(string) && "$id".equals(string3) && "$db".equals(string4)) {
                if (elementType == ElementType.STRING) {
                    if (elementType2 == ElementType.STRING) {
                        return new DocumentReference(((StringElement)element4).getValue(), ((StringElement)element).getValue(), element3);
                    }
                    if (elementType2 == ElementType.SYMBOL) {
                        return new DocumentReference(((SymbolElement)element4).getSymbol(), ((StringElement)element).getValue(), element3);
                    }
                } else if (elementType == ElementType.SYMBOL) {
                    if (elementType2 == ElementType.STRING) {
                        return new DocumentReference(((StringElement)element4).getValue(), ((SymbolElement)element).getSymbol(), element3);
                    }
                    if (elementType2 == ElementType.SYMBOL) {
                        return new DocumentReference(((SymbolElement)element4).getSymbol(), ((SymbolElement)element).getSymbol(), element3);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            DocumentElement documentElement = (DocumentElement)element;
            int n2 = Math.min(this.myElements.size(), documentElement.myElements.size());
            for (int i = 0; i < n2; ++i) {
                n = this.myElements.get(i).compareTo(documentElement.myElements.get(i));
                if (n == 0) continue;
                return n;
            }
            n = this.myElements.size() - documentElement.myElements.size();
        }
        return n;
    }

    @Override
    public boolean contains(String string) {
        return this.getElementMap().containsKey(string);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            DocumentElement documentElement = (DocumentElement)object;
            bl = super.equals(object) && this.myElements.equals(documentElement.myElements);
        }
        return bl;
    }

    @Override
    public <E extends Element> List<E> find(Class<E> clazz, String ... stringArray) {
        List<Object> list = Collections.emptyList();
        if (0 < stringArray.length) {
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            list = new ArrayList();
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                for (Element element : this.myElements) {
                    if (!pattern.matcher(element.getName()).matches()) continue;
                    list.addAll(element.find(clazz, stringArray2));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                for (Element element : this.myElements) {
                    if (!string.equals(element.getName())) continue;
                    list.addAll(element.find(clazz, stringArray2));
                }
            }
        } else if (clazz.isAssignableFrom(this.getClass())) {
            list = Collections.singletonList(clazz.cast(this));
        }
        return list;
    }

    @Override
    public <E extends Element> E findFirst(Class<E> clazz, String ... stringArray) {
        Element element = null;
        if (0 < stringArray.length) {
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                Iterator<Element> iterator = this.myElements.iterator();
                while (iterator.hasNext() && element == null) {
                    Element element2 = iterator.next();
                    if (!pattern.matcher(element2.getName()).matches()) continue;
                    element = element2.findFirst(clazz, stringArray2);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Iterator<Element> iterator = this.myElements.iterator();
                while (iterator.hasNext() && element == null) {
                    Element element3 = iterator.next();
                    if (!string.equals(element3.getName())) continue;
                    element = element3.findFirst(clazz, stringArray2);
                }
            }
        } else if (clazz.isAssignableFrom(this.getClass())) {
            element = (Element)clazz.cast(this);
        }
        return (E)element;
    }

    @Override
    public <E extends Element> E get(Class<E> clazz, String string) {
        Element element = this.get(string);
        if (element != null && clazz.isAssignableFrom(element.getClass())) {
            return (E)((Element)clazz.cast(element));
        }
        return null;
    }

    @Override
    public Element get(String string) {
        return this.getElementMap().get(string);
    }

    public Document getDocument() {
        return new RootDocument(this.myElements);
    }

    @Override
    public List<Element> getElements() {
        return this.myElements;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Document getValueAsObject() {
        return BuilderFactory.start((DocumentAssignable)this).build();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myElements.hashCode();
        return n;
    }

    public boolean isDocumentReference() {
        int n = this.myElements.size();
        if (n == 2) {
            Element element = this.myElements.get(0);
            Element element2 = this.myElements.get(1);
            String string = element.getName();
            ElementType elementType = element.getType();
            String string2 = element2.getName();
            return "$ref".equals(string) && (elementType == ElementType.STRING || elementType == ElementType.SYMBOL) && "$id".equals(string2);
        }
        if (this.myElements.size() == 3) {
            Element element = this.myElements.get(0);
            Element element3 = this.myElements.get(1);
            Element element4 = this.myElements.get(2);
            String string = element.getName();
            ElementType elementType = element.getType();
            String string3 = element3.getName();
            String string4 = element4.getName();
            ElementType elementType2 = element4.getType();
            return !(!"$ref".equals(string) || elementType != ElementType.STRING && elementType != ElementType.SYMBOL || !"$id".equals(string3) || !"$db".equals(string4) || elementType2 != ElementType.STRING && elementType2 != ElementType.SYMBOL);
        }
        return false;
    }

    @Override
    public Iterator<Element> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public DocumentElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new DocumentElement(string, this.myElements);
    }

    private Map<String, Element> getElementMap() {
        if (this.myElementMap == null) {
            List<Element> list = this.myElements;
            HashMap<String, Element> hashMap = new HashMap<String, Element>(list.size() + list.size());
            for (Element element : list) {
                hashMap.put(element.getName(), element);
            }
            this.myElementMap = hashMap;
        }
        return this.myElementMap;
    }
}

