/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;

public class JavaScriptElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.JAVA_SCRIPT;
    private static final long serialVersionUID = -180121123367519947L;
    private final String myJavaScript;

    private static long computeSize(String string, String string2) {
        long l = 7L;
        l += (long)StringEncoder.utf8Size(string);
        return l += (long)StringEncoder.utf8Size(string2);
    }

    public JavaScriptElement(String string, String string2) {
        this(string, string2, JavaScriptElement.computeSize(string, string2));
    }

    public JavaScriptElement(String string, String string2, long l) {
        super(string, l);
        Assertions.assertNotNull(string2, "JavaScript element's code block cannot be null.");
        this.myJavaScript = string2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitJavaScript(this.getName(), this.getJavaScript());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            JavaScriptElement javaScriptElement = (JavaScriptElement)element;
            n = this.myJavaScript.compareTo(javaScriptElement.myJavaScript);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            JavaScriptElement javaScriptElement = (JavaScriptElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.myJavaScript, javaScriptElement.myJavaScript);
        }
        return bl;
    }

    public String getJavaScript() {
        return this.myJavaScript;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Object getValueAsObject() {
        return this.getJavaScript();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myJavaScript != null ? this.myJavaScript.hashCode() : 3);
        return n;
    }

    @Override
    public JavaScriptElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new JavaScriptElement(string, this.myJavaScript);
    }
}

