/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;

public class ObjectIdElement
extends AbstractElement {
    public static final String DEFAULT_NAME = "_id";
    public static final ElementType TYPE = ElementType.OBJECT_ID;
    private static final long serialVersionUID = -3563737127052573642L;
    private final ObjectId myId;

    private static long computeSize(String string) {
        long l = 14L;
        return l += (long)StringEncoder.utf8Size(string);
    }

    public ObjectIdElement(String string, ObjectId objectId) {
        this(string, objectId, ObjectIdElement.computeSize(string));
    }

    public ObjectIdElement(String string, ObjectId objectId, long l) {
        super(string, l);
        Assertions.assertNotNull(objectId, "ObjectId element's id cannot be null.");
        this.myId = objectId;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitObjectId(this.getName(), this.myId);
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            ObjectIdElement objectIdElement = (ObjectIdElement)element;
            n = this.myId.compareTo(objectIdElement.myId);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            ObjectIdElement objectIdElement = (ObjectIdElement)object;
            bl = super.equals(object) && this.myId.equals(objectIdElement.myId);
        }
        return bl;
    }

    public ObjectId getId() {
        return this.myId;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public ObjectId getValueAsObject() {
        return this.myId;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myId.hashCode();
        return n;
    }

    @Override
    public ObjectIdElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new ObjectIdElement(string, this.myId);
    }
}

