/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;
import java.util.regex.Pattern;

public class RegularExpressionElement
extends AbstractElement {
    public static final int CASE_INSENSITIVE;
    public static final int DOT_ALL;
    public static final int LOCALE_DEPENDENT;
    public static final int MULTILINE;
    public static final int OPTION_I;
    public static final int OPTION_L;
    public static final int OPTION_M;
    public static final int OPTION_MASK;
    public static final int OPTION_S;
    public static final int OPTION_U;
    public static final int OPTION_X;
    public static final ElementType TYPE;
    public static final int UNICODE;
    public static final int VERBOSE;
    protected static final int PATTERN_UNICODE;
    private static final String[] OPTIONS;
    private static final long serialVersionUID = 7842839168833403380L;
    private final int myOptions;
    private final String myPattern;

    protected static int optionsAsInt(Pattern pattern) {
        int n = 0;
        if (pattern != null) {
            int n2 = pattern.flags();
            if ((n2 & 2) == 2) {
                n |= CASE_INSENSITIVE;
            }
            if ((n2 & 8) == 8) {
                n |= MULTILINE;
            }
            if ((n2 & 0x20) == 32) {
                n |= DOT_ALL;
            }
            if ((n2 & PATTERN_UNICODE) == PATTERN_UNICODE) {
                n |= UNICODE;
            }
        }
        return n;
    }

    protected static int optionsAsInt(String string) {
        int n = 0;
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (c == 'i' || c == 'I') {
                    n |= OPTION_I;
                    continue;
                }
                if (c == 'l' || c == 'L') {
                    n |= OPTION_L;
                    continue;
                }
                if (c == 'm' || c == 'M') {
                    n |= OPTION_M;
                    continue;
                }
                if (c == 's' || c == 'S') {
                    n |= OPTION_S;
                    continue;
                }
                if (c == 'u' || c == 'U') {
                    n |= OPTION_U;
                    continue;
                }
                if (c == 'x' || c == 'X') {
                    n |= OPTION_X;
                    continue;
                }
                throw new IllegalArgumentException("Invalid regular expression option '" + c + "' in options '" + string + "'.");
            }
        }
        return n;
    }

    private static long computeSize(String string, String string2, int n) {
        long l = 4L;
        l += (long)StringEncoder.utf8Size(string);
        l += (long)StringEncoder.utf8Size(string2);
        return l += (long)OPTIONS[n & OPTION_MASK].length();
    }

    public RegularExpressionElement(String string, Pattern pattern) {
        this(string, pattern != null ? pattern.pattern() : null, RegularExpressionElement.optionsAsInt(pattern));
    }

    public RegularExpressionElement(String string, String string2, int n) {
        super(string, RegularExpressionElement.computeSize(string, string2, n));
        Assertions.assertNotNull(string2, "Regular Expression element's pattern cannot be null.");
        this.myPattern = string2;
        this.myOptions = n;
    }

    public RegularExpressionElement(String string, String string2, int n, long l) {
        super(string, l);
        Assertions.assertNotNull(string2, "Regular Expression element's pattern cannot be null.");
        this.myPattern = string2;
        this.myOptions = n;
    }

    public RegularExpressionElement(String string, String string2, String string3) {
        this(string, string2, RegularExpressionElement.optionsAsInt(string3));
    }

    public RegularExpressionElement(String string, String string2, String string3, long l) {
        this(string, string2, RegularExpressionElement.optionsAsInt(string3), l);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitRegularExpression(this.getName(), this.getPattern(), OPTIONS[this.getOptions() & OPTION_MASK]);
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            RegularExpressionElement regularExpressionElement = (RegularExpressionElement)element;
            n = this.myPattern.compareTo(regularExpressionElement.myPattern);
            if (n == 0) {
                n = RegularExpressionElement.compare(this.myOptions, regularExpressionElement.myOptions);
            }
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            RegularExpressionElement regularExpressionElement = (RegularExpressionElement)object;
            bl = this.myOptions == regularExpressionElement.myOptions && super.equals(object) && this.nullSafeEquals(this.myPattern, regularExpressionElement.myPattern);
        }
        return bl;
    }

    public int getOptions() {
        return this.myOptions;
    }

    public String getPattern() {
        return this.myPattern;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Pattern getValueAsObject() {
        int n = 0;
        if ((this.myOptions & CASE_INSENSITIVE) == CASE_INSENSITIVE) {
            n |= 2;
        }
        if ((this.myOptions & MULTILINE) == MULTILINE) {
            n |= 8;
        }
        if ((this.myOptions & DOT_ALL) == DOT_ALL) {
            n |= 0x20;
        }
        if ((this.myOptions & UNICODE) == UNICODE) {
            n |= PATTERN_UNICODE;
        }
        return Pattern.compile(this.myPattern, n);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myPattern != null ? this.myPattern.hashCode() : 3);
        n = 31 * n + this.myOptions;
        return n;
    }

    @Override
    public RegularExpressionElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new RegularExpressionElement(string, this.myPattern, this.myOptions);
    }

    static {
        TYPE = ElementType.REGEX;
        OPTION_I = 1;
        OPTION_L = 2;
        OPTION_M = 4;
        OPTION_S = 8;
        OPTION_U = 16;
        OPTION_X = 32;
        OPTION_MASK = 63;
        CASE_INSENSITIVE = OPTION_I;
        LOCALE_DEPENDENT = OPTION_L;
        MULTILINE = OPTION_M;
        DOT_ALL = OPTION_S;
        UNICODE = OPTION_U;
        VERBOSE = OPTION_X;
        String[] stringArray = new String[OPTION_MASK + 1];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < OPTION_MASK + 1; ++i) {
            stringBuilder.setLength(0);
            if ((i & OPTION_I) == OPTION_I) {
                stringBuilder.append('i');
            }
            if ((i & OPTION_L) == OPTION_L) {
                stringBuilder.append('l');
            }
            if ((i & OPTION_M) == OPTION_M) {
                stringBuilder.append('m');
            }
            if ((i & OPTION_S) == OPTION_S) {
                stringBuilder.append('s');
            }
            if ((i & OPTION_U) == OPTION_U) {
                stringBuilder.append('u');
            }
            if ((i & OPTION_X) == OPTION_X) {
                stringBuilder.append('x');
            }
            stringArray[i] = stringBuilder.toString();
        }
        OPTIONS = stringArray;
        PATTERN_UNICODE = 256;
    }
}

