/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;

public class StringElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.STRING;
    private static final long serialVersionUID = 2279503881395893379L;
    private final String myValue;

    static int utf8Compare(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 0;
        for (int i = 0; n5 < n3 && i < n4; n5 += Character.charCount(n2), i += Character.charCount(n)) {
            n2 = Character.codePointAt(string, n5);
            int n6 = StringElement.compare(n2, n = Character.codePointAt(string2, i));
            if (n6 == 0) continue;
            return n6;
        }
        return StringElement.compare(n3, n4);
    }

    private static long computeSize(String string, String string2) {
        long l = 7L;
        l += (long)StringEncoder.utf8Size(string);
        return l += (long)StringEncoder.utf8Size(string2);
    }

    public StringElement(String string, String string2) {
        this(string, string2, StringElement.computeSize(string, string2));
    }

    public StringElement(String string, String string2, long l) {
        super(string, l);
        Assertions.assertNotNull(string2, "String element's value cannot be null.");
        this.myValue = string2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitString(this.getName(), this.getValue());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            ElementType elementType = element.getType();
            n = elementType == ElementType.SYMBOL ? StringElement.utf8Compare(this.myValue, ((SymbolElement)element).getSymbol()) : StringElement.utf8Compare(this.myValue, ((StringElement)element).getValue());
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            StringElement stringElement = (StringElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.myValue, stringElement.myValue);
        }
        return bl;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public String getValue() {
        return this.myValue;
    }

    @Override
    public String getValueAsObject() {
        return this.getValue();
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myValue != null ? this.myValue.hashCode() : 3);
        return n;
    }

    @Override
    public StringElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new StringElement(string, this.myValue);
    }
}

