/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.impl;

import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.impl.AbstractDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImmutableDocument
extends AbstractDocument {
    private static final long serialVersionUID = -2875918328146027037L;
    private volatile Map<String, Element> myElementMap;
    private final List<Element> myElements;
    private transient long mySize;

    public ImmutableDocument(DocumentAssignable documentAssignable) {
        List<Element> list = documentAssignable.asDocument().getElements();
        this.myElements = Collections.unmodifiableList(new ArrayList<Element>(list));
        this.myElementMap = null;
        this.mySize = this.computeSize();
    }

    public ImmutableDocument(DocumentAssignable documentAssignable, long l) {
        List<Element> list = documentAssignable.asDocument().getElements();
        this.myElements = Collections.unmodifiableList(new ArrayList<Element>(list));
        this.myElementMap = null;
        this.mySize = l;
    }

    @Override
    public List<Element> getElements() {
        return this.myElements;
    }

    @Override
    public long size() {
        return this.mySize;
    }

    @Override
    protected Map<String, Element> getElementMap() {
        if (this.myElementMap == null) {
            HashMap<String, Element> hashMap = new HashMap<String, Element>(this.myElements.size() << 1);
            for (Element element : this.myElements) {
                hashMap.put(element.getName(), element);
            }
            this.myElementMap = hashMap;
        }
        return this.myElementMap;
    }

    private long computeSize() {
        long l = 5L;
        for (Element element : this.myElements) {
            l += element.size();
        }
        return l;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.mySize = this.computeSize();
    }
}

