/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.impl;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.impl.AbstractDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class RootDocument
extends AbstractDocument {
    private static final long serialVersionUID = -2875918328146027036L;
    final AtomicReference<List<Element>> myElements = new AtomicReference();
    final boolean myIdKnownPresent;
    private final AtomicReference<Map<String, Element>> myElementMap = new AtomicReference();
    private transient long mySize;

    private static long computeSize(List<Element> list) {
        long l = 5L;
        if (list != null && !list.isEmpty()) {
            for (Element element : list) {
                l += element.size();
            }
        }
        return l;
    }

    public RootDocument(Element ... elementArray) {
        this(Arrays.asList(elementArray), false);
    }

    public RootDocument(List<Element> list) {
        this(list, false);
    }

    public RootDocument(List<Element> list, boolean bl) {
        this(list, bl, RootDocument.computeSize(list));
    }

    public RootDocument(List<Element> list, boolean bl, long l) {
        if (list != null && !list.isEmpty()) {
            this.myElements.set(Collections.unmodifiableList(new ArrayList<Element>(list)));
        } else {
            this.myElements.set(EMPTY_ELEMENTS);
        }
        this.myIdKnownPresent = bl;
        this.mySize = l;
    }

    @Override
    public boolean contains(String string) {
        return this.myIdKnownPresent && "_id".equals(string) || super.contains(string);
    }

    @Override
    public List<Element> getElements() {
        return this.myElements.get();
    }

    public void injectId() {
        if (!this.contains("_id")) {
            List<Element> list = this.myElements.get();
            ObjectIdElement objectIdElement = new ObjectIdElement("_id", new ObjectId());
            ArrayList<Element> arrayList = new ArrayList<Element>(list.size() + 1);
            arrayList.add(objectIdElement);
            arrayList.addAll(list);
            if (this.myElements.compareAndSet(list, arrayList)) {
                this.myElementMap.set(null);
                this.mySize += objectIdElement.size();
            }
        }
    }

    @Override
    public long size() {
        return this.mySize;
    }

    @Override
    protected Map<String, Element> getElementMap() {
        if (this.myElementMap.get() == null) {
            List<Element> list = this.myElements.get();
            HashMap<String, Element> hashMap = new HashMap<String, Element>(list.size() + list.size());
            for (Element element : list) {
                hashMap.put(element.getName(), element);
            }
            this.myElementMap.compareAndSet(null, hashMap);
        }
        return this.myElementMap.get();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.mySize = RootDocument.computeSize(this.getElements());
    }
}

