/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DBPointerElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.bson.element.JavaScriptWithScopeElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.MaxKeyElement;
import com.allanbank.mongodb.bson.element.MinKeyElement;
import com.allanbank.mongodb.bson.element.MongoTimestampElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import com.allanbank.mongodb.bson.io.EndianUtils;
import com.allanbank.mongodb.bson.io.StringDecoder;
import com.allanbank.mongodb.bson.io.StringDecoderCache;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class BsonInputStream
extends InputStream {
    public static final Charset UTF8 = StringDecoder.UTF8;
    private byte[] myBuffer;
    private int myBufferLimit;
    private int myBufferOffset;
    private long myBytesRead;
    private final InputStream myInput;
    private final StringDecoder myStringDecoder;

    public BsonInputStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public BsonInputStream(InputStream inputStream, int n) {
        this(inputStream, n, new StringDecoderCache());
    }

    public BsonInputStream(InputStream inputStream, int n, StringDecoderCache stringDecoderCache) {
        this.myInput = inputStream;
        this.myBuffer = new byte[n];
        this.myBufferOffset = 0;
        this.myBufferLimit = 0;
        this.myBytesRead = 0L;
        this.myStringDecoder = new StringDecoder(stringDecoderCache);
    }

    public BsonInputStream(InputStream inputStream, StringDecoderCache stringDecoderCache) {
        this(inputStream, 8192, stringDecoderCache);
    }

    @Override
    public int available() throws IOException {
        return this.availableInBuffer() + this.myInput.available();
    }

    @Override
    public void close() throws IOException {
        this.myInput.close();
    }

    public long getBytesRead() {
        return this.myBytesRead + (long)this.myBufferOffset;
    }

    @Deprecated
    public int getMaxCachedStringEntries() {
        return this.myStringDecoder.getCache().getMaxCacheEntries();
    }

    @Deprecated
    public int getMaxCachedStringLength() {
        return this.myStringDecoder.getCache().getMaxCacheLength();
    }

    @Override
    public synchronized void mark(int n) {
        throw new UnsupportedOperationException("Mark not supported.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public final void prefetch(int n) throws IOException {
        this.fetch(n, false);
    }

    @Override
    public int read() throws IOException {
        if (this.ensureFetched(1) != 1) {
            return -1;
        }
        int n = this.myBuffer[this.myBufferOffset] & 0xFF;
        ++this.myBufferOffset;
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.ensureFetched(n2 - n);
        System.arraycopy(this.myBuffer, this.myBufferOffset, byArray, n, n3);
        this.myBufferOffset += n3;
        return n3;
    }

    public String readCString() throws EOFException, IOException {
        while (true) {
            for (int i = this.myBufferOffset; i < this.myBufferLimit; ++i) {
                byte by = this.myBuffer[i];
                if (by != 0) continue;
                int n = this.myBufferOffset;
                int n2 = 1 + i - n;
                this.myBufferOffset = i + 1;
                return this.myStringDecoder.decode(this.myBuffer, n, n2);
            }
            this.ensureFetched(this.availableInBuffer() + 1);
        }
    }

    public Document readDocument() throws IOException {
        int n = this.readInt();
        this.prefetch(n - 4);
        return new RootDocument(this.readElements(), false, n);
    }

    public void readFully(byte[] byArray) throws EOFException, IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public int readInt() throws EOFException, IOException {
        if (this.ensureFetched(4) != 4) {
            throw new EOFException();
        }
        int n = this.myBuffer[this.myBufferOffset] & 0xFF;
        n += (this.myBuffer[this.myBufferOffset + 1] & 0xFF) << 8;
        n += (this.myBuffer[this.myBufferOffset + 2] & 0xFF) << 16;
        this.myBufferOffset += 4;
        return n += (this.myBuffer[this.myBufferOffset + 3] & 0xFF) << 24;
    }

    public long readLong() throws EOFException, IOException {
        if (this.ensureFetched(8) != 8) {
            throw new EOFException();
        }
        long l = (long)this.myBuffer[this.myBufferOffset] & 0xFFL;
        l += ((long)this.myBuffer[this.myBufferOffset + 1] & 0xFFL) << 8;
        l += ((long)this.myBuffer[this.myBufferOffset + 2] & 0xFFL) << 16;
        l += ((long)this.myBuffer[this.myBufferOffset + 3] & 0xFFL) << 24;
        l += ((long)this.myBuffer[this.myBufferOffset + 4] & 0xFFL) << 32;
        l += ((long)this.myBuffer[this.myBufferOffset + 5] & 0xFFL) << 40;
        l += ((long)this.myBuffer[this.myBufferOffset + 6] & 0xFFL) << 48;
        this.myBufferOffset += 8;
        return l += ((long)this.myBuffer[this.myBufferOffset + 7] & 0xFFL) << 56;
    }

    @Override
    public synchronized void reset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mark not supported.");
    }

    @Deprecated
    public void setMaxCachedStringEntries(int n) {
        this.myStringDecoder.getCache().setMaxCacheEntries(n);
    }

    @Deprecated
    public void setMaxCachedStringLength(int n) {
        this.myStringDecoder.getCache().setMaxCacheLength(n);
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = Math.min(l, (long)this.availableInBuffer());
        this.myBufferOffset = (int)((long)this.myBufferOffset + l2);
        if (l2 < l) {
            long l3 = this.myInput.skip(l - l2);
            this.myBytesRead += l3;
            l2 += l3;
        }
        return l2;
    }

    protected final int availableInBuffer() {
        return this.myBufferLimit - this.myBufferOffset;
    }

    protected ArrayElement readArrayElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        int n = this.readInt();
        this.prefetch(n - 4);
        List<Element> list = this.readElements();
        long l2 = this.getBytesRead() - l;
        return new ArrayElement(string, list, l2);
    }

    protected BinaryElement readBinaryElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        int n = this.readInt();
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        if (n2 == 2) {
            int n3 = this.readInt();
            assert (n3 == n - 4) : "Binary Element Subtye 2 length should be outer length - 4.";
            n -= 4;
        } else if (n2 == 3 || n2 == 4) {
            byte[] byArray = new byte[n];
            this.readFully(byArray);
            long l2 = this.getBytesRead() - l;
            try {
                return new UuidElement(string, (byte)n2, byArray, l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new BinaryElement(string, (byte)n2, byArray, l2);
            }
        }
        long l3 = this.getBytesRead() - l;
        return new BinaryElement(string, (byte)n2, this, n, l3 + (long)n);
    }

    protected BooleanElement readBooleanElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        boolean bl = this.read() == 1;
        long l2 = this.getBytesRead() - l;
        return new BooleanElement(string, bl, l2);
    }

    @Deprecated
    protected Element readDBPointerElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        String string2 = this.readString();
        int n = EndianUtils.swap(this.readInt());
        long l2 = EndianUtils.swap(this.readLong());
        long l3 = this.getBytesRead() - l;
        String string3 = string2;
        String string4 = "";
        int n2 = string2.indexOf(46);
        if (0 <= n2) {
            string3 = string2.substring(0, n2);
            string4 = string2.substring(n2 + 1);
        }
        return new DBPointerElement(string, string3, string4, new ObjectId(n, l2), l3);
    }

    protected DocumentElement readDocumentElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        int n = this.readInt();
        this.prefetch(n - 4);
        List<Element> list = this.readElements();
        long l2 = this.getBytesRead() - l;
        return new DocumentElement(string, list, true, l2);
    }

    protected DoubleElement readDoubleElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        double d = Double.longBitsToDouble(this.readLong());
        long l2 = this.getBytesRead() - l;
        return new DoubleElement(string, d, l2);
    }

    protected Element readElement(byte by) throws EOFException, IOException {
        ElementType elementType = ElementType.valueOf(by);
        if (elementType == null) {
            throw new StreamCorruptedException("Unknown element type: 0x" + Integer.toHexString(by & 0xFF) + ".");
        }
        switch (elementType) {
            case ARRAY: {
                return this.readArrayElement();
            }
            case BINARY: {
                return this.readBinaryElement();
            }
            case DB_POINTER: {
                return this.readDBPointerElement();
            }
            case DOCUMENT: {
                return this.readDocumentElement();
            }
            case DOUBLE: {
                return this.readDoubleElement();
            }
            case BOOLEAN: {
                return this.readBooleanElement();
            }
            case INTEGER: {
                return this.readIntegerElement();
            }
            case JAVA_SCRIPT: {
                return this.readJavaScriptElement();
            }
            case JAVA_SCRIPT_WITH_SCOPE: {
                return this.readJavaScriptWithScopeElement();
            }
            case LONG: {
                return this.readLongElement();
            }
            case MAX_KEY: {
                return this.readMaxKeyElement();
            }
            case MIN_KEY: {
                return this.readMinKeyElement();
            }
            case MONGO_TIMESTAMP: {
                return this.readMongoTimestampElement();
            }
            case NULL: {
                return this.readNullElement();
            }
            case OBJECT_ID: {
                return this.readObjectIdElement();
            }
            case REGEX: {
                return this.readRegularExpressionElement();
            }
            case STRING: {
                return this.readStringElement();
            }
            case SYMBOL: {
                return this.readSymbolElement();
            }
            case UTC_TIMESTAMP: {
                return this.readTimestampElement();
            }
        }
        throw new StreamCorruptedException("Unknown element type: " + elementType.name() + ".");
    }

    protected List<Element> readElements() throws EOFException, IOException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = this.read();
        while (n > 0) {
            arrayList.add(this.readElement((byte)n));
            n = this.read();
        }
        if (n < 0) {
            throw new EOFException();
        }
        return arrayList;
    }

    protected IntegerElement readIntegerElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        int n = this.readInt();
        long l2 = this.getBytesRead() - l;
        return new IntegerElement(string, n, l2);
    }

    protected JavaScriptElement readJavaScriptElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        String string2 = this.readString();
        long l2 = this.getBytesRead() - l;
        return new JavaScriptElement(string, string2, l2);
    }

    protected JavaScriptWithScopeElement readJavaScriptWithScopeElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        this.readInt();
        String string2 = this.readString();
        Document document = this.readDocument();
        long l2 = this.getBytesRead() - l;
        return new JavaScriptWithScopeElement(string, string2, document, l2);
    }

    protected LongElement readLongElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        long l2 = this.readLong();
        long l3 = this.getBytesRead() - l;
        return new LongElement(string, l2, l3);
    }

    protected MaxKeyElement readMaxKeyElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        long l2 = this.getBytesRead() - l;
        return new MaxKeyElement(string, l2);
    }

    protected MinKeyElement readMinKeyElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        long l2 = this.getBytesRead() - l;
        return new MinKeyElement(string, l2);
    }

    protected MongoTimestampElement readMongoTimestampElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        long l2 = this.readLong();
        long l3 = this.getBytesRead() - l;
        return new MongoTimestampElement(string, l2, l3);
    }

    protected NullElement readNullElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        long l2 = this.getBytesRead() - l;
        return new NullElement(string, l2);
    }

    protected ObjectIdElement readObjectIdElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        int n = EndianUtils.swap(this.readInt());
        long l2 = EndianUtils.swap(this.readLong());
        long l3 = this.getBytesRead() - l;
        return new ObjectIdElement(string, new ObjectId(n, l2), l3);
    }

    protected RegularExpressionElement readRegularExpressionElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        String string2 = this.readCString();
        String string3 = this.readCString();
        long l2 = this.getBytesRead() - l;
        return new RegularExpressionElement(string, string2, string3, l2);
    }

    protected String readString() throws EOFException, IOException {
        int n = this.readInt();
        if (this.ensureFetched(n) != n) {
            throw new EOFException();
        }
        int n2 = this.myBufferOffset;
        this.myBufferOffset += n;
        return this.myStringDecoder.decode(this.myBuffer, n2, n);
    }

    protected StringElement readStringElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        String string2 = this.readString();
        long l2 = this.getBytesRead() - l;
        return new StringElement(string, string2, l2);
    }

    protected SymbolElement readSymbolElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        String string2 = this.readString();
        long l2 = this.getBytesRead() - l;
        return new SymbolElement(string, string2, l2);
    }

    protected TimestampElement readTimestampElement() throws IOException {
        long l = this.getBytesRead() - 1L;
        String string = this.readCString();
        long l2 = this.readLong();
        long l3 = this.getBytesRead() - l;
        return new TimestampElement(string, l2, l3);
    }

    private final int ensureFetched(int n) throws IOException {
        return this.fetch(n, true);
    }

    private final int fetch(int n, boolean bl) throws IOException {
        int n2 = this.availableInBuffer();
        if (n2 < n) {
            int n3;
            if (this.myBuffer.length < n) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.myBuffer, this.myBufferOffset, byArray, 0, n2);
                this.myBuffer = byArray;
            } else if (0 < n2) {
                System.arraycopy(this.myBuffer, this.myBufferOffset, this.myBuffer, 0, n2);
            }
            this.myBytesRead += (long)this.myBufferOffset;
            this.myBufferOffset = 0;
            this.myBufferLimit = n2;
            do {
                if (0 >= (n3 = this.myInput.read(this.myBuffer, this.myBufferLimit, this.myBuffer.length - this.myBufferLimit))) continue;
                n2 += n3;
                this.myBufferLimit += n3;
            } while (bl && 0 <= n3 && n2 < n);
            return Math.min(n, n2);
        }
        return n;
    }

    private void readFully(byte[] byArray, int n, int n2) throws EOFException, IOException {
        int n3 = Math.min(n2, this.availableInBuffer());
        System.arraycopy(this.myBuffer, this.myBufferOffset, byArray, n, n3);
        this.myBufferOffset += n3;
        while (n3 < n2) {
            int n4 = this.myInput.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            this.myBytesRead += (long)(n3 += n4);
        }
    }
}

