/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.io.StringDecoder;
import com.allanbank.mongodb.bson.io.StringEncoder;
import java.nio.charset.Charset;
import java.util.List;

public class SizeOfVisitor
implements Visitor {
    public static final Charset UTF8 = StringDecoder.UTF8;
    private int mySize = 0;
    private final StringEncoder myStringEncoder;

    public SizeOfVisitor() {
        this(null);
    }

    public SizeOfVisitor(StringEncoder stringEncoder) {
        this.myStringEncoder = stringEncoder;
    }

    public int computeCStringSize(String string) {
        return this.utf8Size(string) + 1;
    }

    public int computeStringSize(String string) {
        return 4 + this.utf8Size(string) + 1;
    }

    public int getSize() {
        return this.mySize;
    }

    public void reset() {
        this.mySize = 0;
    }

    public void rewind() {
        this.mySize = 0;
    }

    public int utf8Size(String string) {
        if (this.myStringEncoder != null) {
            return this.myStringEncoder.encodeSize(string);
        }
        return StringEncoder.utf8Size(string);
    }

    @Override
    public void visit(List<Element> list) {
        this.mySize += 4;
        for (Element element : list) {
            if (element.getType() == ElementType.BINARY) {
                BinaryElement binaryElement = (BinaryElement)element;
                this.doVisitBinary(binaryElement.getName(), binaryElement.getSubType(), binaryElement.length());
                continue;
            }
            element.accept(this);
        }
        ++this.mySize;
    }

    @Override
    public void visitArray(String string, List<Element> list) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.visit(list);
    }

    @Override
    public void visitBinary(String string, byte by, byte[] byArray) {
        int n = byArray.length;
        this.doVisitBinary(string, by, n);
    }

    @Override
    public void visitBoolean(String string, boolean bl) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        ++this.mySize;
    }

    @Override
    public void visitDBPointer(String string, String string2, String string3, ObjectId objectId) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2 + "." + string3);
        this.mySize += 12;
    }

    @Override
    public void visitDocument(String string, List<Element> list) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.visit(list);
    }

    @Override
    public void visitDouble(String string, double d) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    @Override
    public void visitInteger(String string, int n) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 4;
    }

    @Override
    public void visitJavaScript(String string, String string2) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2);
    }

    @Override
    public void visitJavaScript(String string, String string2, Document document) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 4;
        this.mySize += this.computeStringSize(string2);
        document.accept(this);
    }

    @Override
    public void visitLong(String string, long l) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    @Override
    public void visitMaxKey(String string) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
    }

    @Override
    public void visitMinKey(String string) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
    }

    @Override
    public void visitMongoTimestamp(String string, long l) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    @Override
    public void visitNull(String string) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
    }

    @Override
    public void visitObjectId(String string, ObjectId objectId) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 12;
    }

    @Override
    public void visitRegularExpression(String string, String string2, String string3) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeCStringSize(string2);
        this.mySize += this.computeCStringSize(string3);
    }

    @Override
    public void visitString(String string, String string2) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2);
    }

    @Override
    public void visitSymbol(String string, String string2) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2);
    }

    @Override
    public void visitTimestamp(String string, long l) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    private void doVisitBinary(String string, byte by, int n) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        switch (by) {
            case 2: {
                this.mySize += 9 + n;
                break;
            }
            default: {
                this.mySize += 5 + n;
            }
        }
    }
}

