/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.io.AbstractStringCache;
import com.allanbank.mongodb.bson.io.SeenString;
import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.util.List;
import java.util.SortedMap;

public class StringDecoderCache
extends AbstractStringCache {
    private TrieCache myTrieCache = new TrieCache();

    public String find(byte[] byArray, int n, int n2) throws StreamCorruptedException, EOFException {
        if (n2 <= 1) {
            return "";
        }
        if (this.myMaxCacheLength < n2) {
            return null;
        }
        if (byArray[n + n2 - 1] != 0) {
            throw new StreamCorruptedException("Expected a null character at the end of the string.");
        }
        return this.myTrieCache.find(byArray, n, n2);
    }

    @Override
    protected void clear() {
        this.myTrieCache = new TrieCache();
        super.clear();
    }

    @Override
    protected void rebuildCache() {
        SortedMap<Integer, List<SeenString>> sortedMap = this.buildCacheGroups();
        TrieCache trieCache = new TrieCache();
        int n = 0;
        for (List<SeenString> list : sortedMap.values()) {
            for (SeenString seenString : list) {
                if (n < this.myMaxCachEntries) {
                    trieCache.addEntry(seenString.getBytes(), seenString.getValue());
                    ++n;
                    continue;
                }
                this.mySeen.remove(seenString.getValue());
            }
        }
        this.myTrieCache = trieCache;
    }

    protected static class TrieCache {
        private final TrieNode[] myRoots = new TrieNode[256];

        public void addEntry(byte[] byArray, String string) {
            int n = byArray.length - 1;
            int n2 = byArray[0] & 0xFF;
            TrieNode trieNode = this.myRoots[n2];
            if (trieNode == null) {
                trieNode = this.myRoots[n2] = new TrieNode(byArray[0]);
            }
            for (int i = 1; i < n; ++i) {
                TrieNode trieNode2 = trieNode.child(byArray[i]);
                if (trieNode2 == null) {
                    trieNode2 = new TrieNode(byArray[i]);
                    trieNode.addChild(trieNode2);
                }
                trieNode = trieNode2;
            }
            trieNode.setDecoded(string);
        }

        public String find(byte[] byArray, int n, int n2) {
            int n3 = n + (n2 - 1);
            int n4 = byArray[n] & 0xFF;
            TrieNode trieNode = this.myRoots[n4];
            for (int n5 = n + 1; trieNode != null && n5 < n3; trieNode = trieNode.child(byArray[n5]), ++n5) {
            }
            return trieNode != null ? trieNode.getDecoded() : null;
        }

        protected static class TrieNode {
            private TrieNode[][] myChildren;
            private String myDecoded;
            private final byte myValue;

            public TrieNode(byte by) {
                this.myValue = by;
                this.myDecoded = null;
                this.myChildren = null;
            }

            public void addChild(TrieNode trieNode) {
                byte by = trieNode.getValue();
                int n = (by & 0xF0) >> 4;
                int n2 = by & 0xF;
                if (this.myChildren == null) {
                    this.myChildren = new TrieNode[16][];
                    this.myChildren[n] = new TrieNode[16];
                } else if (this.myChildren[n] == null) {
                    this.myChildren[n] = new TrieNode[16];
                }
                this.myChildren[n][n2] = trieNode;
            }

            public TrieNode child(byte by) {
                int n = (by & 0xF0) >> 4;
                int n2 = by & 0xF;
                if (this.myChildren != null && this.myChildren[n] != null) {
                    return this.myChildren[n][n2];
                }
                return null;
            }

            public String getDecoded() {
                return this.myDecoded;
            }

            public byte getValue() {
                return this.myValue;
            }

            public void setDecoded(String string) {
                this.myDecoded = string;
            }
        }
    }
}

