/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.io.StringEncoderCache;
import java.io.IOException;
import java.io.OutputStream;

public class StringEncoder {
    private final byte[] myBuffer = new byte[1024];
    private final StringEncoderCache myCache;

    public static int computeCStringSize(String string) {
        return StringEncoder.utf8Size(string) + 1;
    }

    public static int computeStringSize(String string) {
        return 4 + StringEncoder.utf8Size(string) + 1;
    }

    public static int utf8Size(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        int n3 = 0;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(string, i);
            if (n < 128) {
                ++n3;
                continue;
            }
            if (n < 2048) {
                n3 += 2;
                continue;
            }
            if (n < 65536) {
                n3 += 3;
                continue;
            }
            n3 += 4;
        }
        return n3;
    }

    public StringEncoder() {
        this(new StringEncoderCache());
    }

    public StringEncoder(StringEncoderCache stringEncoderCache) {
        this.myCache = stringEncoderCache;
    }

    public void encode(String string, OutputStream outputStream) throws IOException {
        if (!string.isEmpty()) {
            byte[] byArray = this.myCache.find(string);
            if (byArray == null) {
                this.fastEncode(string, outputStream);
            } else {
                this.myCache.used(string, byArray, 0, byArray.length);
                outputStream.write(byArray);
            }
        }
    }

    public int encodeSize(String string) {
        if (string.isEmpty()) {
            return 0;
        }
        byte[] byArray = this.myCache.find(string);
        if (byArray != null) {
            return byArray.length;
        }
        return StringEncoder.utf8Size(string);
    }

    @Deprecated
    public StringEncoderCache getCache() {
        return this.myCache;
    }

    protected void fastEncode(String string, OutputStream outputStream) throws IOException {
        int n;
        int n2 = this.myBuffer.length - 4;
        int n3 = string.length();
        boolean bl = true;
        int n4 = 0;
        for (int i = 0; i < n3; i += Character.charCount(n)) {
            if (n2 < n4) {
                bl = false;
                if (outputStream != null) {
                    outputStream.write(this.myBuffer, 0, n4);
                }
                n4 = 0;
            }
            if ((n = Character.codePointAt(string, i)) < 128) {
                this.myBuffer[n4++] = (byte)n;
                continue;
            }
            if (n < 2048) {
                this.myBuffer[n4++] = (byte)(192 + (n >> 6 & 0xFF));
                this.myBuffer[n4++] = (byte)(128 + (n >> 0 & 0x3F));
                continue;
            }
            if (n < 65536) {
                this.myBuffer[n4++] = (byte)(224 + (n >> 12 & 0xFF));
                this.myBuffer[n4++] = (byte)(128 + (n >> 6 & 0x3F));
                this.myBuffer[n4++] = (byte)(128 + (n >> 0 & 0x3F));
                continue;
            }
            this.myBuffer[n4++] = (byte)(240 + (n >> 18 & 0xFF));
            this.myBuffer[n4++] = (byte)(128 + (n >> 12 & 0x3F));
            this.myBuffer[n4++] = (byte)(128 + (n >> 6 & 0x3F));
            this.myBuffer[n4++] = (byte)(128 + (n >> 0 & 0x3F));
        }
        if (outputStream != null) {
            outputStream.write(this.myBuffer, 0, n4);
        }
        if (bl) {
            this.myCache.used(string, this.myBuffer, 0, n4);
        }
    }
}

