/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.SizeAwareVisitor;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.EndianUtils;
import com.allanbank.mongodb.bson.io.StringEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class WriteVisitor
implements SizeAwareVisitor {
    protected final BsonOutputStream myOutput;

    public WriteVisitor(BsonOutputStream bsonOutputStream) {
        this.myOutput = bsonOutputStream;
    }

    public WriteVisitor(OutputStream outputStream) {
        this(new BsonOutputStream(outputStream));
    }

    public IOException getError() {
        return this.myOutput.getError();
    }

    public boolean hasError() {
        return this.myOutput.hasError();
    }

    public void reset() {
        this.myOutput.reset();
    }

    @Deprecated
    public int sizeOf(Document document) {
        return (int)document.size();
    }

    public int utf8Size(String string) {
        return StringEncoder.utf8Size(string);
    }

    @Override
    public void visit(List<Element> list) {
        int n = 5;
        for (Element element : list) {
            n = (int)((long)n + element.size());
        }
        this.writeElements(list, n);
    }

    @Override
    public void visitArray(String string, List<Element> list) {
        this.myOutput.writeByte(ElementType.ARRAY.getToken());
        this.myOutput.writeCString(string);
        this.visit(list);
    }

    @Override
    public void visitArray(String string, List<Element> list, long l) {
        this.myOutput.writeByte(ElementType.ARRAY.getToken());
        this.myOutput.writeCString(string);
        this.writeElements(list, (int)l - (this.myOutput.sizeOfCString(string) + 1));
    }

    @Override
    public void visitBinary(String string, byte by, byte[] byArray) {
        this.myOutput.writeByte(ElementType.BINARY.getToken());
        this.myOutput.writeCString(string);
        switch (by) {
            case 2: {
                this.myOutput.writeInt(byArray.length + 4);
                this.myOutput.writeByte(by);
                this.myOutput.writeInt(byArray.length);
                this.myOutput.writeBytes(byArray);
                break;
            }
            default: {
                this.myOutput.writeInt(byArray.length);
                this.myOutput.writeByte(by);
                this.myOutput.writeBytes(byArray);
            }
        }
    }

    @Override
    public void visitBoolean(String string, boolean bl) {
        this.myOutput.writeByte(ElementType.BOOLEAN.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public void visitDBPointer(String string, String string2, String string3, ObjectId objectId) {
        this.myOutput.writeByte(ElementType.DB_POINTER.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2 + "." + string3);
        this.myOutput.writeInt(EndianUtils.swap(objectId.getTimestamp()));
        this.myOutput.writeLong(EndianUtils.swap(objectId.getMachineId()));
    }

    @Override
    public void visitDocument(String string, List<Element> list) {
        this.myOutput.writeByte(ElementType.DOCUMENT.getToken());
        this.myOutput.writeCString(string);
        this.visit(list);
    }

    @Override
    public void visitDocument(String string, List<Element> list, long l) {
        this.myOutput.writeByte(ElementType.DOCUMENT.getToken());
        this.myOutput.writeCString(string);
        this.writeElements(list, (int)l - (this.myOutput.sizeOfCString(string) + 1));
    }

    @Override
    public void visitDouble(String string, double d) {
        this.myOutput.writeByte(ElementType.DOUBLE.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void visitInteger(String string, int n) {
        this.myOutput.writeByte(ElementType.INTEGER.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeInt(n);
    }

    @Override
    public void visitJavaScript(String string, String string2) {
        this.myOutput.writeByte(ElementType.JAVA_SCRIPT.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2);
    }

    @Override
    public void visitJavaScript(String string, String string2, Document document) {
        this.myOutput.writeByte(ElementType.JAVA_SCRIPT_WITH_SCOPE.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeInt(4 + StringEncoder.computeStringSize(string2) + (int)document.size());
        this.myOutput.writeString(string2);
        document.accept(this);
    }

    @Override
    public void visitLong(String string, long l) {
        this.myOutput.writeByte(ElementType.LONG.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(l);
    }

    @Override
    public void visitMaxKey(String string) {
        this.myOutput.writeByte(ElementType.MAX_KEY.getToken());
        this.myOutput.writeCString(string);
    }

    @Override
    public void visitMinKey(String string) {
        this.myOutput.writeByte(ElementType.MIN_KEY.getToken());
        this.myOutput.writeCString(string);
    }

    @Override
    public void visitMongoTimestamp(String string, long l) {
        this.myOutput.writeByte(ElementType.MONGO_TIMESTAMP.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(l);
    }

    @Override
    public void visitNull(String string) {
        this.myOutput.writeByte(ElementType.NULL.getToken());
        this.myOutput.writeCString(string);
    }

    @Override
    public void visitObjectId(String string, ObjectId objectId) {
        this.myOutput.writeByte(ElementType.OBJECT_ID.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeInt(EndianUtils.swap(objectId.getTimestamp()));
        this.myOutput.writeLong(EndianUtils.swap(objectId.getMachineId()));
    }

    @Override
    public void visitRegularExpression(String string, String string2, String string3) {
        this.myOutput.writeByte(ElementType.REGEX.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeCString(string2);
        this.myOutput.writeCString(string3);
    }

    @Override
    public void visitString(String string, String string2) {
        this.myOutput.writeByte(ElementType.STRING.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2);
    }

    @Override
    public void visitSymbol(String string, String string2) {
        this.myOutput.writeByte(ElementType.SYMBOL.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2);
    }

    @Override
    public void visitTimestamp(String string, long l) {
        this.myOutput.writeByte(ElementType.UTC_TIMESTAMP.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(l);
    }

    protected void writeElements(List<Element> list, int n) {
        this.myOutput.writeInt(n);
        for (Element element : list) {
            element.accept(this);
        }
        this.myOutput.writeByte((byte)0);
    }
}

