/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.AggregationGeoNear;
import com.allanbank.mongodb.builder.AggregationGroupField;
import com.allanbank.mongodb.builder.AggregationGroupId;
import com.allanbank.mongodb.builder.AggregationProjectFields;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.RedactOption;
import com.allanbank.mongodb.builder.Sort;
import com.allanbank.mongodb.builder.expression.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Aggregate {
    public static final Version ALLOW_DISK_USAGE_REQUIRED_VERSION = Version.parse("2.6");
    public static final Version CURSOR_VERSION = Version.parse("2.5.2");
    public static final Version EXPLAIN_VERSION = Version.parse("2.5.3");
    public static final Version GEO_NEAR_REQUIRED_VERSION = Version.VERSION_2_4;
    public static final Version MAX_TIMEOUT_VERSION = Find.MAX_TIMEOUT_VERSION;
    public static final Version REDACT_REQUIRED_VERSION = Version.parse("2.5.2");
    public static final Version REQUIRED_VERSION = Version.parse("2.1.0");
    private final boolean myAllowDiskUsage;
    private final int myBatchSize;
    private final int myLimit;
    private final long myMaximumTimeMilliseconds;
    private final List<Element> myPipeline;
    private final ReadPreference myReadPreference;
    private final Version myRequiredVersion;
    private final boolean myUseCursor;

    public static Builder builder() {
        return new Builder();
    }

    protected Aggregate(Builder builder) {
        this.myPipeline = Collections.unmodifiableList(Arrays.asList(builder.myPipeline.build()));
        this.myBatchSize = builder.myBatchSize;
        this.myLimit = builder.myLimit;
        this.myUseCursor = builder.myUseCursor;
        this.myAllowDiskUsage = builder.myAllowDiskUsage;
        this.myReadPreference = builder.myReadPreference;
        this.myRequiredVersion = builder.myRequiredVersion;
        this.myMaximumTimeMilliseconds = builder.myMaximumTimeMilliseconds;
    }

    public int getBatchSize() {
        return this.myBatchSize;
    }

    public int getCursorLimit() {
        return this.myLimit;
    }

    public long getMaximumTimeMilliseconds() {
        return this.myMaximumTimeMilliseconds;
    }

    public List<Element> getPipeline() {
        return this.myPipeline;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public Version getRequiredVersion() {
        return this.myRequiredVersion;
    }

    public boolean isAllowDiskUsage() {
        return this.myAllowDiskUsage;
    }

    public boolean isUseCursor() {
        return this.myUseCursor;
    }

    public static class Builder {
        protected boolean myAllowDiskUsage;
        protected int myBatchSize;
        protected int myLimit;
        protected long myMaximumTimeMilliseconds;
        protected final ArrayBuilder myPipeline = BuilderFactory.startArray();
        protected ReadPreference myReadPreference;
        protected Version myRequiredVersion;
        protected boolean myUseCursor;

        public Builder() {
            this.reset();
        }

        public Builder allowDiskUsage() {
            return this.allowDiskUsage(true);
        }

        public Builder allowDiskUsage(boolean bl) {
            return this.setAllowDiskUsage(bl);
        }

        public Builder batchSize(int n) {
            return this.setBatchSize(n);
        }

        public Aggregate build() {
            return new Aggregate(this);
        }

        public Builder cursorLimit(int n) {
            return this.setCusorLimit(n);
        }

        public Builder geoNear(AggregationGeoNear aggregationGeoNear) {
            this.myRequiredVersion = Version.later(this.myRequiredVersion, GEO_NEAR_REQUIRED_VERSION);
            return this.step("$geoNear", aggregationGeoNear.asDocument());
        }

        public Builder geoNear(AggregationGeoNear.Builder builder) {
            return this.geoNear(builder.build());
        }

        public Builder group(AggregationGroupId aggregationGroupId, AggregationGroupField ... aggregationGroupFieldArray) {
            Element[] elementArray = new Element[aggregationGroupFieldArray.length + 1];
            elementArray[0] = aggregationGroupId.toElement();
            for (int i = 0; i < aggregationGroupFieldArray.length; ++i) {
                elementArray[i + 1] = aggregationGroupFieldArray[i].toElement();
            }
            return this.step("$group", elementArray);
        }

        public Builder group(AggregationGroupId.Builder builder, AggregationGroupField ... aggregationGroupFieldArray) {
            return this.group(builder.buildId(), aggregationGroupFieldArray);
        }

        public Builder group(DocumentAssignable documentAssignable) {
            return this.step("$group", documentAssignable);
        }

        public Builder group(DocumentAssignable documentAssignable, AggregationGroupField ... aggregationGroupFieldArray) {
            return this.group(new AggregationGroupId(documentAssignable), aggregationGroupFieldArray);
        }

        public Builder limit(int n) {
            return this.step("$limit", n);
        }

        public Builder limit(long l) {
            return this.step("$limit", l);
        }

        public Builder match(DocumentAssignable documentAssignable) {
            return this.step("$match", documentAssignable);
        }

        public Builder maximumTime(long l, TimeUnit timeUnit) {
            return this.setMaximumTimeMilliseconds(timeUnit.toMillis(l));
        }

        public Builder out(String string) {
            this.setReadPreference(ReadPreference.PRIMARY);
            return this.step("$out", string);
        }

        public Builder project(AggregationProjectFields aggregationProjectFields, Element ... elementArray) {
            List<IntegerElement> list = aggregationProjectFields.toElements();
            ArrayList<Element> arrayList = new ArrayList<Element>(list.size() + elementArray.length);
            arrayList.addAll(list);
            arrayList.addAll(Arrays.asList(elementArray));
            return this.step("$project", arrayList);
        }

        public Builder project(DocumentAssignable documentAssignable) {
            return this.step("$project", documentAssignable);
        }

        public Builder redact(DocumentAssignable documentAssignable, RedactOption redactOption, RedactOption redactOption2) {
            this.myRequiredVersion = Version.later(this.myRequiredVersion, REDACT_REQUIRED_VERSION);
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.push("$cond").add(new DocumentElement("if", documentAssignable.asDocument())).add("then", redactOption.getToken()).add("else", redactOption2.getToken());
            return this.step("$redact", documentBuilder);
        }

        public Builder redact(Expression expression, RedactOption redactOption, RedactOption redactOption2) {
            this.myRequiredVersion = Version.later(this.myRequiredVersion, REDACT_REQUIRED_VERSION);
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.push("$cond").add(expression.toElement("if")).add("then", redactOption.getToken()).add("else", redactOption2.getToken());
            return this.step("$redact", documentBuilder);
        }

        public Builder reset() {
            this.myPipeline.reset();
            this.myReadPreference = null;
            this.myMaximumTimeMilliseconds = 0L;
            this.myBatchSize = 0;
            this.myLimit = 0;
            this.myUseCursor = false;
            this.myAllowDiskUsage = false;
            this.myRequiredVersion = REQUIRED_VERSION;
            return this;
        }

        public Builder setAllowDiskUsage(boolean bl) {
            this.myRequiredVersion = Version.later(this.myRequiredVersion, ALLOW_DISK_USAGE_REQUIRED_VERSION);
            this.myAllowDiskUsage = bl;
            return this.setUseCursor(true);
        }

        public Builder setBatchSize(int n) {
            this.myBatchSize = n;
            return this.setUseCursor(true);
        }

        public Builder setCusorLimit(int n) {
            this.myLimit = n;
            return this.setUseCursor(true);
        }

        public Builder setMaximumTimeMilliseconds(long l) {
            this.myRequiredVersion = Version.later(this.myRequiredVersion, MAX_TIMEOUT_VERSION);
            this.myMaximumTimeMilliseconds = l;
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }

        public Builder setUseCursor(boolean bl) {
            this.myRequiredVersion = Version.later(this.myRequiredVersion, CURSOR_VERSION);
            this.myUseCursor = bl;
            return this;
        }

        public Builder skip(int n) {
            return this.step("$skip", n);
        }

        public Builder skip(long l) {
            return this.step("$skip", l);
        }

        public Builder sort(IntegerElement ... integerElementArray) {
            return this.step("$sort", integerElementArray);
        }

        public Builder sort(String ... stringArray) {
            IntegerElement[] integerElementArray = new IntegerElement[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                integerElementArray[i] = Sort.asc(stringArray[i]);
            }
            return this.sort(integerElementArray);
        }

        public Builder step(String string, DocumentAssignable documentAssignable) {
            this.myPipeline.push().addDocument(string, documentAssignable.asDocument());
            return this;
        }

        public Builder step(String string, double d) {
            this.myPipeline.push().addDouble(string, d);
            return this;
        }

        public Builder step(String string, Element ... elementArray) {
            return this.step(string, Arrays.asList(elementArray));
        }

        public Builder step(String string, int n) {
            this.myPipeline.push().addInteger(string, n);
            return this;
        }

        public Builder step(String string, List<Element> list) {
            DocumentBuilder documentBuilder = this.myPipeline.push().push(string);
            for (Element element : list) {
                documentBuilder.add(element);
            }
            return this;
        }

        public Builder step(String string, long l) {
            this.myPipeline.push().addLong(string, l);
            return this;
        }

        public Builder step(String string, String string2) {
            this.myPipeline.push().addString(string, string2);
            return this;
        }

        public String toString() {
            return new ArrayElement("$pipeline", this.build().getPipeline()).toString();
        }

        public Builder unwind(String string) {
            if (string.startsWith("$")) {
                this.step("$unwind", string);
            } else {
                this.step("$unwind", "$" + string);
            }
            return this;
        }

        public Builder useCursor() {
            return this.setUseCursor(true);
        }

        public Builder useCursor(boolean bl) {
            return this.setUseCursor(bl);
        }
    }
}

