/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.impl.EmptyDocument;
import com.allanbank.mongodb.builder.BatchedWriteMode;
import com.allanbank.mongodb.builder.write.DeleteOperation;
import com.allanbank.mongodb.builder.write.InsertOperation;
import com.allanbank.mongodb.builder.write.UpdateOperation;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.builder.write.WriteOperationType;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class BatchedWrite
implements Serializable {
    public static final Version REQUIRED_VERSION = Version.parse("2.5.5");
    private static final long serialVersionUID = 6984498574755719178L;
    private final Durability myDurability;
    private final BatchedWriteMode myMode;
    private final List<WriteOperation> myWrites;

    public static Builder builder() {
        return new Builder();
    }

    public static BatchedWrite delete(DocumentAssignable documentAssignable, boolean bl, Durability durability) {
        DeleteOperation deleteOperation = new DeleteOperation(documentAssignable, bl);
        return new BatchedWrite(deleteOperation, BatchedWriteMode.SERIALIZE_AND_CONTINUE, durability);
    }

    public static BatchedWrite insert(boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) {
        ArrayList<WriteOperation> arrayList = new ArrayList<WriteOperation>(documentAssignableArray.length);
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            arrayList.add(new InsertOperation(documentAssignable));
        }
        return new BatchedWrite(arrayList, bl ? BatchedWriteMode.SERIALIZE_AND_CONTINUE : BatchedWriteMode.SERIALIZE_AND_STOP, durability);
    }

    public static BatchedWrite update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) {
        UpdateOperation updateOperation = new UpdateOperation(documentAssignable, documentAssignable2, bl, bl2);
        return new BatchedWrite(updateOperation, BatchedWriteMode.SERIALIZE_AND_CONTINUE, durability);
    }

    protected BatchedWrite(Builder builder) {
        this.myWrites = Collections.unmodifiableList(new ArrayList<WriteOperation>(builder.myWrites));
        this.myMode = builder.myMode;
        this.myDurability = builder.myDurability;
    }

    private BatchedWrite(List<WriteOperation> list, BatchedWriteMode batchedWriteMode, Durability durability) {
        this.myWrites = Collections.unmodifiableList(list);
        this.myMode = batchedWriteMode;
        this.myDurability = durability;
    }

    private BatchedWrite(WriteOperation writeOperation, BatchedWriteMode batchedWriteMode, Durability durability) {
        this(Collections.singletonList(writeOperation), batchedWriteMode, durability);
    }

    public Durability getDurability() {
        return this.myDurability;
    }

    public BatchedWriteMode getMode() {
        return this.myMode;
    }

    public List<WriteOperation> getWrites() {
        return this.myWrites;
    }

    public List<Bundle> toBundles(String string, long l, int n) {
        switch (this.getMode()) {
            case REORDERED: {
                return this.createOptimized(string, l, n);
            }
            case SERIALIZE_AND_CONTINUE: {
                return this.createSerialized(string, l, n, false);
            }
        }
        return this.createSerialized(string, l, n, true);
    }

    private void add(ArrayBuilder arrayBuilder, WriteOperation writeOperation) {
        switch (writeOperation.getType()) {
            case INSERT: {
                InsertOperation insertOperation = (InsertOperation)writeOperation;
                arrayBuilder.add(insertOperation.getDocument());
                break;
            }
            case UPDATE: {
                UpdateOperation updateOperation = (UpdateOperation)writeOperation;
                DocumentBuilder documentBuilder = arrayBuilder.push();
                documentBuilder.add("q", updateOperation.getQuery());
                documentBuilder.add("u", updateOperation.getUpdate());
                if (updateOperation.isUpsert()) {
                    documentBuilder.add("upsert", true);
                }
                if (!updateOperation.isMultiUpdate()) break;
                documentBuilder.add("multi", true);
                break;
            }
            case DELETE: {
                DeleteOperation deleteOperation = (DeleteOperation)writeOperation;
                arrayBuilder.push().add("q", deleteOperation.getQuery()).add("limit", deleteOperation.isSingleDelete() ? 1 : 0);
                break;
            }
        }
    }

    private void addDurability(DocumentBuilder documentBuilder, Durability durability) {
        if (durability != null) {
            DocumentBuilder documentBuilder2 = documentBuilder.push("writeConcern");
            if (durability.equals(Durability.NONE)) {
                documentBuilder2.add("w", 0);
            } else if (durability.equals(Durability.ACK)) {
                documentBuilder2.add("w", 1);
            } else {
                boolean bl = true;
                for (Element element : durability.asDocument()) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    documentBuilder2.add(element);
                }
            }
        }
    }

    private DocumentToLargeException createDocumentToLargeException(WriteOperation writeOperation, int n, int n2) {
        Document document = EmptyDocument.INSTANCE;
        switch (writeOperation.getType()) {
            case INSERT: {
                InsertOperation insertOperation = (InsertOperation)writeOperation;
                document = insertOperation.getDocument();
                break;
            }
            case UPDATE: {
                UpdateOperation updateOperation = (UpdateOperation)writeOperation;
                document = updateOperation.getQuery();
                Document document2 = updateOperation.getUpdate();
                if (document.size() >= document2.size()) break;
                document = document2;
                break;
            }
            case DELETE: {
                DeleteOperation deleteOperation = (DeleteOperation)writeOperation;
                document = deleteOperation.getQuery();
                break;
            }
        }
        return new DocumentToLargeException(n, n2, document);
    }

    private List<Bundle> createOptimized(String string, long l, int n) {
        Object object;
        Object object2;
        SortedMap sortedMap2;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (WriteOperation serializable2 : this.getWrites()) {
            sortedMap2 = (TreeMap)linkedHashMap.get((Object)serializable2.getType());
            if (sortedMap2 == null) {
                sortedMap2 = new TreeMap();
                linkedHashMap.put(serializable2.getType(), sortedMap2);
            }
            if ((object2 = (LinkedList<WriteOperation>)sortedMap2.get(object = Long.valueOf(this.sizeOf(-1, serializable2)))) == null) {
                object2 = new LinkedList<WriteOperation>();
                sortedMap2.put(object, object2);
            }
            object2.add(serializable2);
        }
        Long l2 = l + 1L;
        for (SortedMap sortedMap2 : linkedHashMap.values()) {
            if (sortedMap2.tailMap(l2).isEmpty()) continue;
            object = (Long)sortedMap2.lastKey();
            object2 = (List)sortedMap2.get(object);
            throw this.createDocumentToLargeException((WriteOperation)object2.get(0), ((Long)object).intValue(), (int)l);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        sortedMap2 = new ArrayList(Math.min(n, this.myWrites.size()));
        object = BuilderFactory.start();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            SortedMap sortedMap3 = (SortedMap)entry.getValue();
            while (!sortedMap3.isEmpty()) {
                ArrayBuilder arrayBuilder = this.start((WriteOperationType)((Object)entry.getKey()), string, false, (DocumentBuilder)object);
                long l3 = l - object.build().size();
                SortedMap sortedMap4 = sortedMap3;
                int n2 = 0;
                while (!sortedMap4.isEmpty() && sortedMap2.size() < n) {
                    Long l4 = (Long)sortedMap4.lastKey();
                    List list = (List)sortedMap4.get(l4);
                    WriteOperation writeOperation = (WriteOperation)list.remove(0);
                    if (list.isEmpty()) {
                        sortedMap4.remove(l4);
                    }
                    this.add(arrayBuilder, writeOperation);
                    sortedMap2.add(writeOperation);
                    sortedMap4 = sortedMap3.headMap((l3 -= this.sizeOf(n2, writeOperation)) - this.sizeOfIndex(++n2));
                }
                arrayList.add(new Bundle(object.build(), (List<WriteOperation>)((Object)sortedMap2)));
                sortedMap2.clear();
            }
        }
        return arrayList;
    }

    private List<Bundle> createSerialized(String string, long l, int n, boolean bl) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        DocumentBuilder documentBuilder = BuilderFactory.start();
        List<WriteOperation> list = this.getWrites();
        ArrayList<WriteOperation> arrayList2 = new ArrayList<WriteOperation>(Math.min(n, this.myWrites.size()));
        ArrayBuilder arrayBuilder = null;
        WriteOperationType writeOperationType = null;
        long l2 = l;
        for (WriteOperation writeOperation : list) {
            long l3 = this.sizeOf(-1, writeOperation);
            long l4 = this.sizeOfIndex(arrayList2.size());
            if (l < l3) {
                throw this.createDocumentToLargeException(writeOperation, (int)l3, (int)l);
            }
            if (!(arrayList2.isEmpty() || writeOperationType == writeOperation.getType() && l2 - (l3 += l4) >= 0L && n > arrayList2.size())) {
                arrayList.add(new Bundle(documentBuilder.build(), arrayList2));
                arrayList2.clear();
            }
            if (arrayList2.isEmpty()) {
                arrayBuilder = this.start(writeOperation.getType(), string, bl, documentBuilder);
                writeOperationType = writeOperation.getType();
                l2 = l - documentBuilder.build().size();
            }
            this.add(arrayBuilder, writeOperation);
            arrayList2.add(writeOperation);
            l2 -= l3;
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(new Bundle(documentBuilder.build(), arrayList2));
        }
        return arrayList;
    }

    private long sizeOf(int n, WriteOperation writeOperation) {
        long l = 0L;
        switch (writeOperation.getType()) {
            case INSERT: {
                InsertOperation insertOperation = (InsertOperation)writeOperation;
                l = this.sizeOfIndex(n) + insertOperation.getDocument().size();
                break;
            }
            case UPDATE: {
                UpdateOperation updateOperation = (UpdateOperation)writeOperation;
                l = this.sizeOfIndex(n) + updateOperation.getQuery().size() + updateOperation.getUpdate().size() + 29L;
                break;
            }
            case DELETE: {
                DeleteOperation deleteOperation = (DeleteOperation)writeOperation;
                l = this.sizeOfIndex(n) + deleteOperation.getQuery().size() + 20L;
                break;
            }
        }
        return l;
    }

    private long sizeOfIndex(int n) {
        if (n < 0) {
            return 0L;
        }
        if (n < 10) {
            return 3L;
        }
        if (n < 100) {
            return 4L;
        }
        if (n < 1000) {
            return 5L;
        }
        if (n < 10000) {
            return 6L;
        }
        return Integer.toString(n).length() + 2;
    }

    private ArrayBuilder start(WriteOperationType writeOperationType, String string, boolean bl, DocumentBuilder documentBuilder) {
        String string2 = "";
        String string3 = "";
        switch (writeOperationType) {
            case INSERT: {
                string2 = "insert";
                string3 = "documents";
                break;
            }
            case UPDATE: {
                string2 = "update";
                string3 = "updates";
                break;
            }
            case DELETE: {
                string2 = "delete";
                string3 = "deletes";
            }
        }
        documentBuilder.reset();
        documentBuilder.add(string2, string);
        if (!bl) {
            documentBuilder.add("ordered", bl);
        }
        this.addDurability(documentBuilder, this.getDurability());
        return documentBuilder.pushArray(string3);
    }

    public static final class Bundle {
        private final Document myCommand;
        private final List<WriteOperation> myWrites;

        protected Bundle(Document document, List<WriteOperation> list) {
            this.myCommand = document;
            this.myWrites = Collections.unmodifiableList(new ArrayList<WriteOperation>(list));
        }

        public Document getCommand() {
            return this.myCommand;
        }

        public List<WriteOperation> getWrites() {
            return this.myWrites;
        }
    }

    public static class Builder {
        protected Durability myDurability;
        protected BatchedWriteMode myMode;
        protected final List<WriteOperation> myWrites = new ArrayList<WriteOperation>();

        public Builder() {
            this.reset();
        }

        public BatchedWrite build() {
            return new BatchedWrite(this);
        }

        public Builder delete(DocumentAssignable documentAssignable) {
            return this.delete(documentAssignable, false);
        }

        public Builder delete(DocumentAssignable documentAssignable, boolean bl) {
            return this.write(new DeleteOperation(documentAssignable, bl));
        }

        public Builder durability(Durability durability) {
            return this.setDurability(durability);
        }

        public Durability getDurability() {
            return this.myDurability;
        }

        public Builder insert(DocumentAssignable documentAssignable) {
            return this.write(new InsertOperation(documentAssignable));
        }

        public Builder mode(BatchedWriteMode batchedWriteMode) {
            return this.setMode(batchedWriteMode);
        }

        public Builder reset() {
            this.myWrites.clear();
            this.myMode = BatchedWriteMode.SERIALIZE_AND_CONTINUE;
            this.myDurability = null;
            return this;
        }

        public Builder save(DocumentAssignable documentAssignable) {
            Document document = documentAssignable.asDocument();
            Element element = document.get("_id");
            if (element == null) {
                return this.insert(document);
            }
            return this.update(BuilderFactory.start().add(element), document, false, true);
        }

        public Builder setDurability(Durability durability) {
            this.myDurability = durability;
            return this;
        }

        public Builder setMode(BatchedWriteMode batchedWriteMode) {
            this.myMode = batchedWriteMode;
            return this;
        }

        public Builder setWrites(List<WriteOperation> list) {
            this.myWrites.clear();
            if (list != null) {
                this.myWrites.addAll(list);
            }
            return this;
        }

        public Builder update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) {
            return this.update(documentAssignable, documentAssignable2, false, false);
        }

        public Builder update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) {
            return this.write(new UpdateOperation(documentAssignable, documentAssignable2, bl, bl2));
        }

        public Builder write(WriteOperation writeOperation) {
            this.myWrites.add(writeOperation);
            return this;
        }

        public Builder writes(List<WriteOperation> list) {
            return this.setWrites(list);
        }
    }
}

