/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.util.Assertions;
import java.util.concurrent.TimeUnit;

public class FindAndModify {
    public static final Document ALL = MongoCollection.ALL;
    public static final Version MAX_TIMEOUT_VERSION = Find.MAX_TIMEOUT_VERSION;
    public static final Document NONE = MongoCollection.NONE;
    private final Document myFields;
    private final long myMaximumTimeMilliseconds;
    private final Document myQuery;
    private final boolean myRemove;
    private final boolean myReturnNew;
    private final Document mySort;
    private final Document myUpdate;
    private final boolean myUpsert;

    public static Builder builder() {
        return new Builder();
    }

    protected FindAndModify(Builder builder) {
        Assertions.assertNotNull(builder.myQuery, "The findAndModify's query document cannot be null or empty.");
        Assertions.assertNotNull(builder.myQuery, "The findAndModify's query document cannot be null or empty.");
        Assertions.assertThat(builder.myUpdate != null || builder.myRemove, "The findAndModify must have an update document or be a remove.");
        this.myQuery = builder.myQuery;
        this.myUpdate = builder.myUpdate;
        this.mySort = builder.mySort;
        this.myFields = builder.myFields;
        this.myUpsert = builder.myUpsert;
        this.myReturnNew = builder.myReturnNew;
        this.myRemove = builder.myRemove;
        this.myMaximumTimeMilliseconds = builder.myMaximumTimeMilliseconds;
    }

    public Document getFields() {
        return this.myFields;
    }

    public long getMaximumTimeMilliseconds() {
        return this.myMaximumTimeMilliseconds;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public Document getSort() {
        return this.mySort;
    }

    public Document getUpdate() {
        return this.myUpdate;
    }

    public boolean isRemove() {
        return this.myRemove;
    }

    public boolean isReturnNew() {
        return this.myReturnNew;
    }

    public boolean isUpsert() {
        return this.myUpsert;
    }

    public static class Builder {
        protected Document myFields;
        protected long myMaximumTimeMilliseconds;
        protected Document myQuery;
        protected boolean myRemove;
        protected boolean myReturnNew;
        protected Document mySort;
        protected Document myUpdate;
        protected boolean myUpsert;

        public Builder() {
            this.reset();
        }

        public FindAndModify build() {
            return new FindAndModify(this);
        }

        public Builder fields(DocumentAssignable documentAssignable) {
            return this.setFields(documentAssignable);
        }

        public Builder maximumTime(long l, TimeUnit timeUnit) {
            return this.setMaximumTimeMilliseconds(timeUnit.toMillis(l));
        }

        public Builder query(DocumentAssignable documentAssignable) {
            return this.setQuery(documentAssignable);
        }

        public Builder remove() {
            return this.setRemove(true);
        }

        public Builder remove(boolean bl) {
            return this.setRemove(bl);
        }

        public Builder reset() {
            this.myFields = null;
            this.myQuery = null;
            this.myRemove = false;
            this.myReturnNew = false;
            this.mySort = null;
            this.myUpdate = null;
            this.myUpsert = false;
            this.myMaximumTimeMilliseconds = 0L;
            return this;
        }

        public Builder returnNew() {
            return this.setReturnNew(true);
        }

        public Builder returnNew(boolean bl) {
            return this.setReturnNew(bl);
        }

        public Builder setFields(DocumentAssignable documentAssignable) {
            this.myFields = documentAssignable.asDocument();
            return this;
        }

        public Builder setMaximumTimeMilliseconds(long l) {
            this.myMaximumTimeMilliseconds = l;
            return this;
        }

        public Builder setQuery(DocumentAssignable documentAssignable) {
            this.myQuery = documentAssignable.asDocument();
            return this;
        }

        public Builder setRemove(boolean bl) {
            this.myRemove = bl;
            return this;
        }

        public Builder setReturnNew(boolean bl) {
            this.myReturnNew = bl;
            return this;
        }

        public Builder setSort(DocumentAssignable documentAssignable) {
            this.mySort = documentAssignable.asDocument();
            return this;
        }

        public Builder setSort(IntegerElement ... integerElementArray) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            for (IntegerElement integerElement : integerElementArray) {
                documentBuilder.add(integerElement);
            }
            this.mySort = documentBuilder.build();
            return this;
        }

        public Builder setUpdate(DocumentAssignable documentAssignable) {
            this.myUpdate = documentAssignable.asDocument();
            return this;
        }

        public Builder setUpsert(boolean bl) {
            this.myUpsert = bl;
            return this;
        }

        public Builder sort(DocumentAssignable documentAssignable) {
            return this.setSort(documentAssignable);
        }

        public Builder sort(IntegerElement ... integerElementArray) {
            return this.setSort(integerElementArray);
        }

        public Builder update(DocumentAssignable documentAssignable) {
            return this.setUpdate(documentAssignable);
        }

        public Builder upsert() {
            return this.setUpsert(true);
        }

        public Builder upsert(boolean bl) {
            return this.setUpsert(bl);
        }
    }
}

