/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.builder.Sort;

public final class Index {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    public static final String GEO_2D_INDEX_NAME = "2d";
    public static final String GEO_2DSPHERE_INDEX_NAME = "2dsphere";
    public static final String GEO_HAYSTACK_INDEX_NAME = "geoHaystack";
    public static final String HASHED_INDEX_NAME = "hashed";
    public static final String TEXT_INDEX_NAME = "text";

    public static IntegerElement asc(String string) {
        return Sort.asc(string);
    }

    public static IntegerElement desc(String string) {
        return Sort.desc(string);
    }

    public static StringElement geo2d(String string) {
        return new StringElement(string, GEO_2D_INDEX_NAME);
    }

    public static StringElement geo2dSphere(String string) {
        return new StringElement(string, GEO_2DSPHERE_INDEX_NAME);
    }

    public static StringElement geoHaystack(String string) {
        return new StringElement(string, GEO_HAYSTACK_INDEX_NAME);
    }

    public static StringElement hashed(String string) {
        return new StringElement(string, HASHED_INDEX_NAME);
    }

    public static StringElement text(String string) {
        return new StringElement(string, TEXT_INDEX_NAME);
    }

    private Index() {
    }
}

