/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder.expression;

import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.MongoTimestampElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.builder.expression.Constant;
import com.allanbank.mongodb.builder.expression.Expression;
import com.allanbank.mongodb.builder.expression.LetBuilder;
import com.allanbank.mongodb.builder.expression.MapStage1;
import com.allanbank.mongodb.builder.expression.NaryExpression;
import com.allanbank.mongodb.builder.expression.UnaryExpression;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public final class Expressions {
    public static final String ADD = "$add";
    public static final String ALL_ELEMENTS_TRUE = "$allElementsTrue";
    public static final String AND = "$and";
    public static final String ANY_ELEMENT_TRUE = "$anyElementTrue";
    public static final String COMPARE = "$cmp";
    public static final String CONCATENATE = "$concat";
    public static final String CONDITION = "$cond";
    public static final String DAY_OF_MONTH = "$dayOfMonth";
    public static final String DAY_OF_WEEK = "$dayOfWeek";
    public static final String DAY_OF_YEAR = "$dayOfYear";
    public static final String DIVIDE = "$divide";
    public static final String EQUAL = "$eq";
    public static final String GREATER_THAN = "$gt";
    public static final String GREATER_THAN_OR_EQUAL = "$gte";
    public static final String HOUR = "$hour";
    public static final String IF_NULL = "$ifNull";
    public static final String LESS_THAN = "$lt";
    public static final String LESS_THAN_OR_EQUAL = "$lte";
    public static final String LITERAL = "$literal";
    public static final String MILLISECOND = "$millisecond";
    public static final String MINUTE = "$minute";
    public static final String MODULO = "$mod";
    public static final String MONTH = "$month";
    public static final String MULTIPLY = "$multiply";
    public static final String NOT = "$not";
    public static final String NOT_EQUAL = "$ne";
    public static final String OR = "$or";
    public static final String SECOND = "$second";
    public static final String SET_DIFFERENCE = "$setDifference";
    public static final String SET_EQUALS = "$setEquals";
    public static final String SET_INTERSECTION = "$setIntersection";
    public static final String SET_IS_SUBSET = "$setIsSubset";
    public static final String SET_UNION = "$setUnion";
    public static final String SIZE = "$size";
    public static final String STRING_CASE_INSENSITIVE_COMPARE = "$strcasecmp";
    public static final String SUB_STRING = "$substr";
    public static final String SUBTRACT = "$subtract";
    public static final String TO_LOWER = "$toLower";
    public static final String TO_UPPER = "$toUpper";
    public static final String WEEK = "$week";
    public static final String YEAR = "$year";

    public static NaryExpression add(Expression ... expressionArray) {
        return new NaryExpression(ADD, expressionArray);
    }

    public static UnaryExpression allElementsTrue(Expression expression) {
        return new UnaryExpression(ALL_ELEMENTS_TRUE, expression);
    }

    public static NaryExpression and(Expression ... expressionArray) {
        return new NaryExpression(AND, expressionArray);
    }

    public static UnaryExpression anyElementTrue(Expression expression) {
        return new UnaryExpression(ANY_ELEMENT_TRUE, expression);
    }

    public static NaryExpression cmp(Expression expression, Expression expression2) {
        return new NaryExpression(COMPARE, expression, expression2);
    }

    public static NaryExpression concatenate(Expression ... expressionArray) {
        return new NaryExpression(CONCATENATE, expressionArray);
    }

    public static NaryExpression cond(Expression expression, Expression expression2, Expression expression3) {
        return new NaryExpression(CONDITION, expression, expression2, expression3);
    }

    public static Constant constant(boolean bl) {
        return new Constant(new BooleanElement("", bl));
    }

    public static Constant constant(Date date) {
        return Expressions.constantTimestamp(date.getTime());
    }

    public static Constant constant(double d) {
        return new Constant(new DoubleElement("", d));
    }

    public static Expression constant(Element element) {
        return new Constant(element);
    }

    public static Constant constant(int n) {
        return new Constant(new IntegerElement("", n));
    }

    public static Constant constant(long l) {
        return new Constant(new LongElement("", l));
    }

    public static Constant constant(ObjectId objectId) {
        return new Constant(new ObjectIdElement("", objectId));
    }

    public static Constant constant(Pattern pattern) {
        return new Constant(new RegularExpressionElement("", pattern));
    }

    public static Constant constant(String string) {
        return new Constant(new StringElement("", string));
    }

    public static Constant constantMongoTimestamp(long l) {
        return new Constant(new MongoTimestampElement("", l));
    }

    public static Constant constantTimestamp(long l) {
        return new Constant(new TimestampElement("", l));
    }

    public static UnaryExpression dayOfMonth(Expression expression) {
        return new UnaryExpression(DAY_OF_MONTH, expression);
    }

    public static UnaryExpression dayOfWeek(Expression expression) {
        return new UnaryExpression(DAY_OF_WEEK, expression);
    }

    public static UnaryExpression dayOfYear(Expression expression) {
        return new UnaryExpression(DAY_OF_YEAR, expression);
    }

    public static NaryExpression divide(Expression expression, Expression expression2) {
        return new NaryExpression(DIVIDE, expression, expression2);
    }

    public static NaryExpression eq(Expression expression, Expression expression2) {
        return new NaryExpression(EQUAL, expression, expression2);
    }

    public static Constant field(String string) {
        if (string.startsWith("$")) {
            return new Constant(new StringElement("", string));
        }
        return new Constant(new StringElement("", "$" + string));
    }

    public static NaryExpression gt(Expression expression, Expression expression2) {
        return new NaryExpression(GREATER_THAN, expression, expression2);
    }

    public static NaryExpression gte(Expression expression, Expression expression2) {
        return new NaryExpression(GREATER_THAN_OR_EQUAL, expression, expression2);
    }

    public static UnaryExpression hour(Expression expression) {
        return new UnaryExpression(HOUR, expression);
    }

    public static NaryExpression ifNull(Expression expression, Expression expression2) {
        return new NaryExpression(IF_NULL, expression, expression2);
    }

    public static UnaryExpression let(Expression expression, Element ... elementArray) {
        return Expressions.let(Arrays.asList(elementArray), expression);
    }

    public static UnaryExpression let(List<Element> list, Expression expression) {
        DocumentBuilder documentBuilder = BuilderFactory.d(new DocumentElement("vars", list), expression.toElement("in"));
        return new UnaryExpression("$let", new Constant(new DocumentElement("$let", documentBuilder.asDocument())));
    }

    public static LetBuilder let(String string, DocumentAssignable documentAssignable) {
        return new LetBuilder(new DocumentElement(string, documentAssignable.asDocument()));
    }

    public static LetBuilder let(String string, Expression expression) {
        return new LetBuilder(expression.toElement(string));
    }

    public static Constant literal(String string) {
        return new Constant(new DocumentElement("", new StringElement(LITERAL, string)));
    }

    public static NaryExpression lt(Expression expression, Expression expression2) {
        return new NaryExpression(LESS_THAN, expression, expression2);
    }

    public static NaryExpression lte(Expression expression, Expression expression2) {
        return new NaryExpression(LESS_THAN_OR_EQUAL, expression, expression2);
    }

    public static MapStage1 map(String string) {
        return new MapStage1(string);
    }

    public static UnaryExpression map(String string, String string2, Expression expression) {
        DocumentBuilder documentBuilder = BuilderFactory.d(Expressions.field(string).toElement("input"), Expressions.constant(string2).toElement("as"), expression.toElement("in"));
        return new UnaryExpression("$map", new Constant(new DocumentElement("$map", documentBuilder.asDocument())));
    }

    public static UnaryExpression millisecond(Expression expression) {
        return new UnaryExpression(MILLISECOND, expression);
    }

    public static UnaryExpression minute(Expression expression) {
        return new UnaryExpression(MINUTE, expression);
    }

    public static NaryExpression mod(Expression expression, Expression expression2) {
        return new NaryExpression(MODULO, expression, expression2);
    }

    public static UnaryExpression month(Expression expression) {
        return new UnaryExpression(MONTH, expression);
    }

    public static NaryExpression multiply(Expression expression, Expression expression2) {
        return new NaryExpression(MULTIPLY, expression, expression2);
    }

    public static NaryExpression ne(Expression expression, Expression expression2) {
        return new NaryExpression(NOT_EQUAL, expression, expression2);
    }

    public static UnaryExpression not(Expression expression) {
        return new UnaryExpression(NOT, expression);
    }

    public static Constant nullConstant() {
        return new Constant(new NullElement(""));
    }

    public static NaryExpression or(Expression ... expressionArray) {
        return new NaryExpression(OR, expressionArray);
    }

    public static UnaryExpression second(Expression expression) {
        return new UnaryExpression(SECOND, expression);
    }

    public static Element set(String string, DocumentAssignable documentAssignable) {
        return new DocumentElement(string, documentAssignable.asDocument());
    }

    public static Element set(String string, Expression expression) {
        return expression.toElement(string);
    }

    public static NaryExpression setDifference(Expression expression, Expression expression2) {
        return new NaryExpression(SET_DIFFERENCE, expression, expression2);
    }

    public static NaryExpression setEquals(Expression expression, Expression expression2) {
        return new NaryExpression(SET_EQUALS, expression, expression2);
    }

    public static NaryExpression setIntersection(Expression expression, Expression expression2) {
        return new NaryExpression(SET_INTERSECTION, expression, expression2);
    }

    public static NaryExpression setIsSubset(Expression expression, Expression expression2) {
        return new NaryExpression(SET_IS_SUBSET, expression, expression2);
    }

    public static NaryExpression setUnion(Expression expression, Expression expression2) {
        return new NaryExpression(SET_UNION, expression, expression2);
    }

    public static UnaryExpression size(Expression expression) {
        return new UnaryExpression(SIZE, expression);
    }

    public static NaryExpression strcasecmp(Expression expression, Expression expression2) {
        return new NaryExpression(STRING_CASE_INSENSITIVE_COMPARE, expression, expression2);
    }

    public static NaryExpression substr(Expression expression, Expression expression2, Expression expression3) {
        return new NaryExpression(SUB_STRING, expression, expression2, expression3);
    }

    public static NaryExpression subtract(Expression expression, Expression expression2) {
        return new NaryExpression(SUBTRACT, expression, expression2);
    }

    public static UnaryExpression toLower(Expression expression) {
        return new UnaryExpression(TO_LOWER, expression);
    }

    public static UnaryExpression toUpper(Expression expression) {
        return new UnaryExpression(TO_UPPER, expression);
    }

    public static Constant var(String string) {
        Constant constant = string.startsWith("$$") ? new Constant(new StringElement("", string)) : (string.startsWith("$") ? new Constant(new StringElement("", "$" + string)) : new Constant(new StringElement("", "$$" + string)));
        return constant;
    }

    public static UnaryExpression week(Expression expression) {
        return new UnaryExpression(WEEK, expression);
    }

    public static UnaryExpression year(Expression expression) {
        return new UnaryExpression(YEAR, expression);
    }

    private Expressions() {
    }
}

