/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder.write;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.builder.write.WriteOperationType;

public class DeleteOperation
implements WriteOperation {
    private static final long serialVersionUID = 3493986989972041392L;
    private final Document myQuery;
    private final boolean mySingleDelete;

    public DeleteOperation(DocumentAssignable documentAssignable, boolean bl) {
        this.myQuery = documentAssignable.asDocument();
        this.mySingleDelete = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            DeleteOperation deleteOperation = (DeleteOperation)object;
            bl = this.mySingleDelete == deleteOperation.mySingleDelete && this.myQuery.equals(deleteOperation.myQuery);
        }
        return bl;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    @Override
    public Document getRoutingDocument() {
        return this.myQuery;
    }

    @Override
    public final WriteOperationType getType() {
        return WriteOperationType.DELETE;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mySingleDelete ? 31 : 11);
        n = 31 * n + this.myQuery.hashCode();
        return n;
    }

    public boolean isSingleDelete() {
        return this.mySingleDelete;
    }

    public String toString() {
        return "Delete[singleDelete=" + this.mySingleDelete + ",query=" + this.myQuery + "]";
    }
}

