/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder.write;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.builder.write.WriteOperationType;

public class UpdateOperation
implements WriteOperation {
    private static final long serialVersionUID = 4657279430768594366L;
    private final boolean myMultiUpdate;
    private final Document myQuery;
    private final Document myUpdate;
    private final boolean myUpsert;

    public UpdateOperation(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) {
        this.myQuery = documentAssignable.asDocument();
        this.myUpdate = documentAssignable2.asDocument();
        this.myUpsert = bl2;
        this.myMultiUpdate = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            UpdateOperation updateOperation = (UpdateOperation)object;
            bl = this.myUpsert == updateOperation.myUpsert && this.myMultiUpdate == updateOperation.myMultiUpdate && this.myQuery.equals(updateOperation.myQuery) && this.myUpdate.equals(updateOperation.myUpdate);
        }
        return bl;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    @Override
    public Document getRoutingDocument() {
        return this.myQuery;
    }

    @Override
    public final WriteOperationType getType() {
        return WriteOperationType.UPDATE;
    }

    public Document getUpdate() {
        return this.myUpdate;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.myUpsert ? 31 : 11);
        n = 31 * n + (this.myMultiUpdate ? 31 : 11);
        n = 31 * n + this.myQuery.hashCode();
        n = 31 * n + this.myUpdate.hashCode();
        return n;
    }

    public boolean isMultiUpdate() {
        return this.myMultiUpdate;
    }

    public boolean isUpsert() {
        return this.myUpsert;
    }

    public String toString() {
        return "Update[upsert=" + this.myUpsert + ",multi=" + this.myMultiUpdate + ",query=" + this.myQuery + ",update=" + this.myUpdate + "]";
    }
}

