/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.AsyncMongoCollection;
import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.LambdaCallback;
import com.allanbank.mongodb.ListenableFuture;
import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.Count;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.ParallelScan;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import com.allanbank.mongodb.client.AbstractMongoOperations;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.FutureCallback;
import com.allanbank.mongodb.client.LambdaCallbackAdapter;
import com.allanbank.mongodb.client.callback.LegacyStreamCallbackAdapter;
import java.util.Collection;

public abstract class AbstractAsyncMongoCollection
extends AbstractMongoOperations
implements AsyncMongoCollection {
    public AbstractAsyncMongoCollection(Client client, MongoDatabase mongoDatabase, String string) {
        super(client, mongoDatabase, string);
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> aggregateAsync(Aggregate aggregate) throws MongoDbException {
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>(this.getLockType());
        this.aggregateAsync(futureCallback, aggregate);
        return futureCallback;
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> aggregateAsync(Aggregate.Builder builder) throws MongoDbException {
        return this.aggregateAsync(builder.build());
    }

    @Override
    public void aggregateAsync(Callback<MongoIterator<Document>> callback, Aggregate.Builder builder) throws MongoDbException {
        this.aggregateAsync(callback, builder.build());
    }

    @Override
    public void aggregateAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, Aggregate aggregate) throws MongoDbException {
        this.aggregateAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), aggregate);
    }

    @Override
    public void aggregateAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, Aggregate.Builder builder) throws MongoDbException {
        this.aggregateAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), builder);
    }

    @Override
    public ListenableFuture<Long> countAsync() throws MongoDbException {
        return this.countAsync(BuilderFactory.start(), this.getReadPreference());
    }

    @Override
    public void countAsync(Callback<Long> callback) throws MongoDbException {
        this.countAsync(callback, (DocumentAssignable)BuilderFactory.start(), this.getReadPreference());
    }

    @Override
    public void countAsync(Callback<Long> callback, Count.Builder builder) throws MongoDbException {
        this.countAsync(callback, builder.build());
    }

    @Override
    public void countAsync(Callback<Long> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.countAsync(callback, documentAssignable, this.getReadPreference());
    }

    @Override
    public void countAsync(Callback<Long> callback, DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        this.countAsync(callback, Count.builder().query(documentAssignable).readPreference(readPreference).build());
    }

    @Override
    public void countAsync(Callback<Long> callback, ReadPreference readPreference) throws MongoDbException {
        this.countAsync(callback, (DocumentAssignable)BuilderFactory.start(), readPreference);
    }

    @Override
    public ListenableFuture<Long> countAsync(Count count) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.countAsync(futureCallback, count);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> countAsync(Count.Builder builder) throws MongoDbException {
        return this.countAsync(builder.build());
    }

    @Override
    public ListenableFuture<Long> countAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.countAsync(futureCallback, documentAssignable, this.getReadPreference());
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> countAsync(DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.countAsync(futureCallback, documentAssignable, readPreference);
        return futureCallback;
    }

    @Override
    public void countAsync(LambdaCallback<Long> lambdaCallback) throws MongoDbException {
        this.countAsync(new LambdaCallbackAdapter<Long>(lambdaCallback));
    }

    @Override
    public void countAsync(LambdaCallback<Long> lambdaCallback, Count count) throws MongoDbException {
        this.countAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), count);
    }

    @Override
    public void countAsync(LambdaCallback<Long> lambdaCallback, Count.Builder builder) throws MongoDbException {
        this.countAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), builder);
    }

    @Override
    public void countAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.countAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable);
    }

    @Override
    public void countAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        this.countAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, readPreference);
    }

    @Override
    public void countAsync(LambdaCallback<Long> lambdaCallback, ReadPreference readPreference) throws MongoDbException {
        this.countAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), readPreference);
    }

    @Override
    public ListenableFuture<Long> countAsync(ReadPreference readPreference) throws MongoDbException {
        return this.countAsync(BuilderFactory.start(), readPreference);
    }

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.deleteAsync(callback, documentAssignable, false, this.getDurability());
    }

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        this.deleteAsync(callback, documentAssignable, bl, this.getDurability());
    }

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        this.deleteAsync(callback, documentAssignable, false, durability);
    }

    @Override
    public ListenableFuture<Long> deleteAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.deleteAsync(futureCallback, documentAssignable, false, this.getDurability());
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> deleteAsync(DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.deleteAsync(futureCallback, documentAssignable, bl, this.getDurability());
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> deleteAsync(DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.deleteAsync(futureCallback, documentAssignable, bl, durability);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> deleteAsync(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.deleteAsync(futureCallback, documentAssignable, false, durability);
        return futureCallback;
    }

    @Override
    public void deleteAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.deleteAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable);
    }

    @Override
    public void deleteAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        this.deleteAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, bl);
    }

    @Override
    public void deleteAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        this.deleteAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, bl, durability);
    }

    @Override
    public void deleteAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        this.deleteAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, durability);
    }

    @Override
    public void distinctAsync(Callback<MongoIterator<Element>> callback, Distinct.Builder builder) throws MongoDbException {
        this.distinctAsync(callback, builder.build());
    }

    @Override
    public ListenableFuture<MongoIterator<Element>> distinctAsync(Distinct distinct) throws MongoDbException {
        FutureCallback<MongoIterator<Element>> futureCallback = new FutureCallback<MongoIterator<Element>>(this.getLockType());
        this.distinctAsync(futureCallback, distinct);
        return futureCallback;
    }

    @Override
    public ListenableFuture<MongoIterator<Element>> distinctAsync(Distinct.Builder builder) throws MongoDbException {
        return this.distinctAsync(builder.build());
    }

    @Override
    public void distinctAsync(LambdaCallback<MongoIterator<Element>> lambdaCallback, Distinct distinct) throws MongoDbException {
        this.distinctAsync(new LambdaCallbackAdapter<MongoIterator<Element>>(lambdaCallback), distinct);
    }

    @Override
    public void distinctAsync(LambdaCallback<MongoIterator<Element>> lambdaCallback, Distinct.Builder builder) throws MongoDbException {
        this.distinctAsync(new LambdaCallbackAdapter<MongoIterator<Element>>(lambdaCallback), builder);
    }

    @Override
    public ListenableFuture<Document> explainAsync(Aggregate aggregate) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.explainAsync(futureCallback, aggregate);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> explainAsync(Aggregate.Builder builder) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.explainAsync(futureCallback, builder.build());
        return futureCallback;
    }

    @Override
    public void explainAsync(Callback<Document> callback, Aggregate.Builder builder) throws MongoDbException {
        this.explainAsync(callback, builder.build());
    }

    @Override
    public void explainAsync(Callback<Document> callback, Find.Builder builder) throws MongoDbException {
        this.explainAsync(callback, builder.build());
    }

    @Override
    public ListenableFuture<Document> explainAsync(Find find) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.explainAsync(futureCallback, find);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> explainAsync(Find.Builder builder) throws MongoDbException {
        return this.explainAsync(builder.build());
    }

    @Override
    public void explainAsync(LambdaCallback<Document> lambdaCallback, Aggregate aggregate) throws MongoDbException {
        this.explainAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), aggregate);
    }

    @Override
    public void explainAsync(LambdaCallback<Document> lambdaCallback, Aggregate.Builder builder) throws MongoDbException {
        this.explainAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), builder);
    }

    @Override
    public void explainAsync(LambdaCallback<Document> lambdaCallback, Find find) throws MongoDbException {
        this.explainAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), find);
    }

    @Override
    public void explainAsync(LambdaCallback<Document> lambdaCallback, Find.Builder builder) throws MongoDbException {
        this.explainAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), builder);
    }

    @Override
    public void findAndModifyAsync(Callback<Document> callback, FindAndModify.Builder builder) throws MongoDbException {
        this.findAndModifyAsync(callback, builder.build());
    }

    @Override
    public ListenableFuture<Document> findAndModifyAsync(FindAndModify findAndModify) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.findAndModifyAsync(futureCallback, findAndModify);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> findAndModifyAsync(FindAndModify.Builder builder) throws MongoDbException {
        return this.findAndModifyAsync(builder.build());
    }

    @Override
    public void findAndModifyAsync(LambdaCallback<Document> lambdaCallback, FindAndModify findAndModify) throws MongoDbException {
        this.findAndModifyAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), findAndModify);
    }

    @Override
    public void findAndModifyAsync(LambdaCallback<Document> lambdaCallback, FindAndModify.Builder builder) throws MongoDbException {
        this.findAndModifyAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), builder);
    }

    @Override
    public void findAsync(Callback<MongoIterator<Document>> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.findAsync(callback, new Find.Builder(documentAssignable).build());
    }

    @Override
    public void findAsync(Callback<MongoIterator<Document>> callback, Find.Builder builder) throws MongoDbException {
        this.findAsync(callback, builder.build());
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> findAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>(this.getLockType());
        this.findAsync(futureCallback, documentAssignable);
        return futureCallback;
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> findAsync(Find find) throws MongoDbException {
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>(this.getLockType());
        this.findAsync(futureCallback, find);
        return futureCallback;
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> findAsync(Find.Builder builder) throws MongoDbException {
        return this.findAsync(builder.build());
    }

    @Override
    public void findAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.findAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), documentAssignable);
    }

    @Override
    public void findAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, Find find) throws MongoDbException {
        this.findAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), find);
    }

    @Override
    public void findAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, Find.Builder builder) throws MongoDbException {
        this.findAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), builder);
    }

    @Override
    public void findOneAsync(Callback<Document> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.findOneAsync(callback, new Find.Builder(documentAssignable).build());
    }

    @Override
    public void findOneAsync(Callback<Document> callback, Find.Builder builder) throws MongoDbException {
        this.findOneAsync(callback, builder.build());
    }

    @Override
    public ListenableFuture<Document> findOneAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.findOneAsync(futureCallback, documentAssignable);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> findOneAsync(Find find) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.findOneAsync(futureCallback, find);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> findOneAsync(Find.Builder builder) throws MongoDbException {
        return this.findOneAsync(builder.build());
    }

    @Override
    public void findOneAsync(LambdaCallback<Document> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.findOneAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), documentAssignable);
    }

    @Override
    public void findOneAsync(LambdaCallback<Document> lambdaCallback, Find find) throws MongoDbException {
        this.findOneAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), find);
    }

    @Override
    public void findOneAsync(LambdaCallback<Document> lambdaCallback, Find.Builder builder) throws MongoDbException {
        this.findOneAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), builder);
    }

    @Override
    public void groupByAsync(Callback<MongoIterator<Element>> callback, GroupBy.Builder builder) throws MongoDbException {
        this.groupByAsync(callback, builder.build());
    }

    @Override
    public ListenableFuture<MongoIterator<Element>> groupByAsync(GroupBy groupBy) throws MongoDbException {
        FutureCallback<MongoIterator<Element>> futureCallback = new FutureCallback<MongoIterator<Element>>(this.getLockType());
        this.groupByAsync(futureCallback, groupBy);
        return futureCallback;
    }

    @Override
    public ListenableFuture<MongoIterator<Element>> groupByAsync(GroupBy.Builder builder) throws MongoDbException {
        return this.groupByAsync(builder.build());
    }

    @Override
    public void groupByAsync(LambdaCallback<MongoIterator<Element>> lambdaCallback, GroupBy groupBy) throws MongoDbException {
        this.groupByAsync(new LambdaCallbackAdapter<MongoIterator<Element>>(lambdaCallback), groupBy);
    }

    @Override
    public void groupByAsync(LambdaCallback<MongoIterator<Element>> lambdaCallback, GroupBy.Builder builder) throws MongoDbException {
        this.groupByAsync(new LambdaCallbackAdapter<MongoIterator<Element>>(lambdaCallback), builder);
    }

    @Override
    public ListenableFuture<Integer> insertAsync(boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>(this.getLockType());
        this.insertAsync(futureCallback, bl, this.getDurability(), documentAssignableArray);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Integer> insertAsync(boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>(this.getLockType());
        this.insertAsync(futureCallback, bl, durability, documentAssignableArray);
        return futureCallback;
    }

    @Override
    public void insertAsync(Callback<Integer> callback, boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(callback, bl, this.getDurability(), documentAssignableArray);
    }

    @Override
    public void insertAsync(Callback<Integer> callback, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(callback, false, this.getDurability(), documentAssignableArray);
    }

    @Override
    public void insertAsync(Callback<Integer> callback, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(callback, false, durability, documentAssignableArray);
    }

    @Override
    public ListenableFuture<Integer> insertAsync(DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>(this.getLockType());
        this.insertAsync(futureCallback, false, this.getDurability(), documentAssignableArray);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Integer> insertAsync(Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>(this.getLockType());
        this.insertAsync(futureCallback, false, durability, documentAssignableArray);
        return futureCallback;
    }

    @Override
    public void insertAsync(LambdaCallback<Integer> lambdaCallback, boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(new LambdaCallbackAdapter<Integer>(lambdaCallback), bl, documentAssignableArray);
    }

    @Override
    public void insertAsync(LambdaCallback<Integer> lambdaCallback, boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(new LambdaCallbackAdapter<Integer>(lambdaCallback), bl, durability, documentAssignableArray);
    }

    @Override
    public void insertAsync(LambdaCallback<Integer> lambdaCallback, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(new LambdaCallbackAdapter<Integer>(lambdaCallback), documentAssignableArray);
    }

    @Override
    public void insertAsync(LambdaCallback<Integer> lambdaCallback, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(new LambdaCallbackAdapter<Integer>(lambdaCallback), durability, documentAssignableArray);
    }

    @Override
    public void mapReduceAsync(Callback<MongoIterator<Document>> callback, MapReduce.Builder builder) throws MongoDbException {
        this.mapReduceAsync(callback, builder.build());
    }

    @Override
    public void mapReduceAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, MapReduce mapReduce) throws MongoDbException {
        this.mapReduceAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), mapReduce);
    }

    @Override
    public void mapReduceAsync(LambdaCallback<MongoIterator<Document>> lambdaCallback, MapReduce.Builder builder) throws MongoDbException {
        this.mapReduceAsync(new LambdaCallbackAdapter<MongoIterator<Document>>(lambdaCallback), builder);
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> mapReduceAsync(MapReduce mapReduce) throws MongoDbException {
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>(this.getLockType());
        this.mapReduceAsync(futureCallback, mapReduce);
        return futureCallback;
    }

    @Override
    public ListenableFuture<MongoIterator<Document>> mapReduceAsync(MapReduce.Builder builder) throws MongoDbException {
        return this.mapReduceAsync(builder.build());
    }

    @Override
    public void parallelScanAsync(Callback<Collection<MongoIterator<Document>>> callback, ParallelScan.Builder builder) throws MongoDbException {
        this.parallelScanAsync(callback, builder.build());
    }

    @Override
    public void parallelScanAsync(LambdaCallback<Collection<MongoIterator<Document>>> lambdaCallback, ParallelScan parallelScan) throws MongoDbException {
        this.parallelScanAsync(new LambdaCallbackAdapter<Collection<MongoIterator<Document>>>(lambdaCallback), parallelScan);
    }

    @Override
    public void parallelScanAsync(LambdaCallback<Collection<MongoIterator<Document>>> lambdaCallback, ParallelScan.Builder builder) throws MongoDbException {
        this.parallelScanAsync(lambdaCallback, builder.build());
    }

    @Override
    public ListenableFuture<Collection<MongoIterator<Document>>> parallelScanAsync(ParallelScan parallelScan) throws MongoDbException {
        FutureCallback<Collection<MongoIterator<Document>>> futureCallback = new FutureCallback<Collection<MongoIterator<Document>>>(this.getLockType());
        this.parallelScanAsync(futureCallback, parallelScan);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Collection<MongoIterator<Document>>> parallelScanAsync(ParallelScan.Builder builder) throws MongoDbException {
        return this.parallelScanAsync(builder.build());
    }

    @Override
    public void saveAsync(Callback<Integer> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.saveAsync(callback, documentAssignable, this.getDurability());
    }

    @Override
    public ListenableFuture<Integer> saveAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>(this.getLockType());
        this.saveAsync(futureCallback, documentAssignable, this.getDurability());
        return futureCallback;
    }

    @Override
    public ListenableFuture<Integer> saveAsync(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>(this.getLockType());
        this.saveAsync(futureCallback, documentAssignable, durability);
        return futureCallback;
    }

    @Override
    public void saveAsync(LambdaCallback<Integer> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.saveAsync(new LambdaCallbackAdapter<Integer>(lambdaCallback), documentAssignable);
    }

    @Override
    public void saveAsync(LambdaCallback<Integer> lambdaCallback, DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        this.saveAsync(new LambdaCallbackAdapter<Integer>(lambdaCallback), documentAssignable, durability);
    }

    @Override
    public MongoCursorControl stream(LambdaCallback<Document> lambdaCallback, Aggregate aggregate) throws MongoDbException {
        return this.stream(new LambdaCallbackAdapter<Document>(lambdaCallback), aggregate);
    }

    @Override
    public MongoCursorControl stream(LambdaCallback<Document> lambdaCallback, Aggregate.Builder builder) throws MongoDbException {
        return this.stream(new LambdaCallbackAdapter<Document>(lambdaCallback), builder);
    }

    @Override
    public MongoCursorControl stream(LambdaCallback<Document> lambdaCallback, Find find) throws MongoDbException {
        return this.stream(new LambdaCallbackAdapter<Document>(lambdaCallback), find);
    }

    @Override
    public MongoCursorControl stream(LambdaCallback<Document> lambdaCallback, Find.Builder builder) throws MongoDbException {
        return this.stream(new LambdaCallbackAdapter<Document>(lambdaCallback), builder);
    }

    @Override
    public MongoCursorControl stream(StreamCallback<Document> streamCallback, Aggregate.Builder builder) throws MongoDbException {
        return this.stream(streamCallback, builder.build());
    }

    @Override
    public MongoCursorControl stream(StreamCallback<Document> streamCallback, Find.Builder builder) throws MongoDbException {
        return this.streamingFind(streamCallback, builder.build());
    }

    @Override
    @Deprecated
    public MongoCursorControl streamingFind(Callback<Document> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.streamingFind(callback, new Find.Builder(documentAssignable).build());
    }

    @Override
    @Deprecated
    public MongoCursorControl streamingFind(Callback<Document> callback, Find find) throws MongoDbException {
        return this.stream((StreamCallback<Document>)new LegacyStreamCallbackAdapter(callback), find);
    }

    @Override
    public MongoCursorControl streamingFind(LambdaCallback<Document> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.streamingFind((StreamCallback<Document>)new LambdaCallbackAdapter<Document>(lambdaCallback), documentAssignable);
    }

    @Override
    public MongoCursorControl streamingFind(StreamCallback<Document> streamCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.stream(streamCallback, new Find.Builder(documentAssignable).build());
    }

    @Override
    @Deprecated
    public MongoCursorControl streamingFind(StreamCallback<Document> streamCallback, Find find) throws MongoDbException {
        return this.stream(streamCallback, find);
    }

    @Override
    @Deprecated
    public MongoCursorControl streamingFind(StreamCallback<Document> streamCallback, Find.Builder builder) throws MongoDbException {
        return this.streamingFind(streamCallback, builder.build());
    }

    @Override
    @Deprecated
    public void textSearchAsync(Callback<MongoIterator<TextResult>> callback, Text.Builder builder) throws MongoDbException {
        this.textSearchAsync(callback, builder.build());
    }

    @Override
    @Deprecated
    public ListenableFuture<MongoIterator<TextResult>> textSearchAsync(Text text) throws MongoDbException {
        FutureCallback<MongoIterator<TextResult>> futureCallback = new FutureCallback<MongoIterator<TextResult>>(this.getLockType());
        this.textSearchAsync(futureCallback, text);
        return futureCallback;
    }

    @Override
    @Deprecated
    public ListenableFuture<MongoIterator<TextResult>> textSearchAsync(Text.Builder builder) throws MongoDbException {
        return this.textSearchAsync(builder.build());
    }

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        this.updateAsync(callback, documentAssignable, documentAssignable2, false, false, this.getDurability());
    }

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        this.updateAsync(callback, documentAssignable, documentAssignable2, bl, bl2, this.getDurability());
    }

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        this.updateAsync(callback, documentAssignable, documentAssignable2, false, false, durability);
    }

    @Override
    public ListenableFuture<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, false, false, this.getDurability());
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, bl, bl2, this.getDurability());
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, bl, bl2, durability);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, false, false, durability);
        return futureCallback;
    }

    @Override
    public void updateAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        this.updateAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, documentAssignable2);
    }

    @Override
    public void updateAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        this.updateAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, documentAssignable2, bl, bl2);
    }

    @Override
    public void updateAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        this.updateAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, documentAssignable2, bl, bl2, durability);
    }

    @Override
    public void updateAsync(LambdaCallback<Long> lambdaCallback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        this.updateAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), documentAssignable, documentAssignable2, durability);
    }

    @Override
    public ListenableFuture<Long> writeAsync(BatchedWrite batchedWrite) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>(this.getLockType());
        this.writeAsync(futureCallback, batchedWrite);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Long> writeAsync(BatchedWrite.Builder builder) throws MongoDbException {
        return this.writeAsync(builder.build());
    }

    @Override
    public void writeAsync(Callback<Long> callback, BatchedWrite.Builder builder) throws MongoDbException {
        this.writeAsync(callback, builder.build());
    }

    @Override
    public void writeAsync(LambdaCallback<Long> lambdaCallback, BatchedWrite batchedWrite) throws MongoDbException {
        this.writeAsync(new LambdaCallbackAdapter<Long>(lambdaCallback), batchedWrite);
    }

    @Override
    public void writeAsync(LambdaCallback<Long> lambdaCallback, BatchedWrite.Builder builder) throws MongoDbException {
        this.writeAsync(lambdaCallback, builder.build());
    }

    protected LockType getLockType() {
        return this.myClient.getConfig().getLockType();
    }
}

