/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.error.MongoClientClosedException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractClient
implements Client {
    private final AtomicBoolean myClosed = new AtomicBoolean(false);

    @Override
    public void close() {
        this.myClosed.set(true);
    }

    @Override
    public void send(Message message, Message message2, ReplyCallback replyCallback) throws MongoDbException {
        this.assertOpen(message);
        this.findConnection(message, message2).send(message, message2, replyCallback);
    }

    @Override
    public void send(Message message, ReplyCallback replyCallback) throws MongoDbException {
        this.assertOpen(message);
        this.findConnection(message, null).send(message, replyCallback);
    }

    protected abstract Connection findConnection(Message var1, Message var2) throws MongoDbException;

    private void assertOpen(Message message) throws MongoClientClosedException {
        if (this.myClosed.get()) {
            throw new MongoClientClosedException(message);
        }
    }
}

