/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.BatchedAsyncMongoCollection;
import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.BatchedWriteMode;
import com.allanbank.mongodb.client.AbstractAsyncMongoCollection;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.ClientImpl;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.SerialClientImpl;
import com.allanbank.mongodb.client.callback.AbstractReplyCallback;
import com.allanbank.mongodb.client.callback.BatchedInsertCountingCallback;
import com.allanbank.mongodb.client.callback.BatchedWriteCallback;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.message.Delete;
import com.allanbank.mongodb.client.message.GetLastError;
import com.allanbank.mongodb.client.message.Insert;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.message.Update;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

public class BatchedAsyncMongoCollectionImpl
extends AbstractAsyncMongoCollection
implements BatchedAsyncMongoCollection {
    private static final Class<?>[] CLIENT_INTERFACE = new Class[]{Client.class};
    private boolean myBatchDeletes = false;
    private boolean myBatchUpdates = false;
    private BatchedWriteMode myMode = BatchedWriteMode.SERIALIZE_AND_CONTINUE;

    public BatchedAsyncMongoCollectionImpl(Client client, MongoDatabase mongoDatabase, String string) {
        super((Client)Proxy.newProxyInstance(BatchedAsyncMongoCollectionImpl.class.getClassLoader(), CLIENT_INTERFACE, (InvocationHandler)new CaptureClientHandler(client)), mongoDatabase, string);
    }

    @Override
    public void cancel() {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.myClient);
        if (invocationHandler instanceof CaptureClientHandler) {
            ((CaptureClientHandler)invocationHandler).clear();
        }
    }

    @Override
    public void close() throws MongoDbException {
        this.flush();
    }

    @Override
    public void flush() throws MongoDbException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.myClient);
        if (invocationHandler instanceof CaptureClientHandler) {
            ((CaptureClientHandler)invocationHandler).flush(this);
        }
    }

    public BatchedWriteMode getMode() {
        return this.myMode;
    }

    public boolean isBatchDeletes() {
        return this.myBatchDeletes;
    }

    public boolean isBatchUpdates() {
        return this.myBatchUpdates;
    }

    @Override
    public void setBatchDeletes(boolean bl) {
        this.myBatchDeletes = bl;
    }

    @Override
    public void setBatchUpdates(boolean bl) {
        this.myBatchUpdates = bl;
    }

    @Override
    public void setMode(BatchedWriteMode batchedWriteMode) {
        this.myMode = batchedWriteMode;
    }

    @Override
    protected boolean useWriteCommand() {
        return false;
    }

    private static class CaptureClientHandler
    implements InvocationHandler {
        public static final Version BATCH_WRITE_VERSION = Version.parse("2.5.4");
        private BatchedAsyncMongoCollectionImpl myCollection;
        private List<Callback<Reply>> myRealCallbacks;
        private final Client myRealClient;
        private List<Object> myResults;
        private final List<Object[]> mySendArgs;
        private final BatchedWrite.Builder myWrite;

        public CaptureClientHandler(Client client) {
            this.myRealClient = client;
            this.myRealCallbacks = null;
            this.myResults = null;
            this.mySendArgs = new LinkedList<Object[]>();
            this.myWrite = BatchedWrite.builder();
        }

        public synchronized void clear() {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(this.mySendArgs);
            this.mySendArgs.clear();
            this.myWrite.reset();
            this.myResults = null;
            this.myRealCallbacks = null;
            this.myCollection = null;
            for (Object[] objectArray : arrayList) {
                Object object = objectArray[objectArray.length - 1];
                if (object instanceof Future) {
                    ((Future)object).cancel(false);
                    continue;
                }
                if (!(object instanceof Callback)) continue;
                ((Callback)object).exception(new CancellationException("Batch request cancelled."));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush(BatchedAsyncMongoCollectionImpl batchedAsyncMongoCollectionImpl) {
            SerialClientImpl serialClientImpl = this.myRealClient instanceof SerialClientImpl ? (SerialClientImpl)this.myRealClient : new SerialClientImpl((ClientImpl)this.myRealClient);
            try {
                List<Object> list = this.optimize(batchedAsyncMongoCollectionImpl);
                for (Object object : list) {
                    Object[] objectArray;
                    if (object instanceof BatchedWriteCallback) {
                        objectArray = (Object[])object;
                        objectArray.setClient(serialClientImpl);
                        objectArray.send();
                        continue;
                    }
                    if (!(object instanceof Object[])) continue;
                    objectArray = (Object[])object;
                    if (objectArray.length == 2) {
                        serialClientImpl.send((Message)objectArray[0], (ReplyCallback)objectArray[1]);
                        continue;
                    }
                    serialClientImpl.send((Message)objectArray[0], (Message)objectArray[1], (ReplyCallback)objectArray[2]);
                }
            }
            finally {
                this.clear();
            }
        }

        @Override
        public synchronized Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("send")) {
                this.mySendArgs.add(objectArray);
                return null;
            }
            return method.invoke((Object)this.myRealClient, objectArray);
        }

        private void addDelete(Delete delete, Object[] objectArray) {
            this.updateDurability(objectArray);
            this.myRealCallbacks.add(this.extractCallback(objectArray));
            this.myWrite.delete(delete.getQuery(), delete.isSingleDelete());
        }

        private void addInsert(Insert insert, Object[] objectArray) {
            boolean bl;
            this.updateDurability(objectArray);
            int n = insert.getDocuments().size();
            BatchedInsertCountingCallback batchedInsertCountingCallback = this.extractCallback(objectArray);
            boolean bl2 = bl = batchedInsertCountingCallback != null && insert.isContinueOnError() && n > 1;
            if (bl) {
                this.closeBatch();
                this.myWrite.setMode(BatchedWriteMode.SERIALIZE_AND_STOP);
            } else {
                batchedInsertCountingCallback = new BatchedInsertCountingCallback(batchedInsertCountingCallback, n);
            }
            for (Document document : insert.getDocuments()) {
                this.myWrite.insert(document);
                this.myRealCallbacks.add(batchedInsertCountingCallback);
            }
            if (bl) {
                this.closeBatch();
            }
        }

        private void addUpdate(Update update, Object[] objectArray) {
            this.updateDurability(objectArray);
            this.myRealCallbacks.add(this.extractCallback(objectArray));
            this.myWrite.update(update.getQuery(), update.getUpdate(), update.isMultiUpdate(), update.isUpsert());
        }

        private void closeBatch() {
            ClusterStats clusterStats = this.myRealClient.getClusterStats();
            BatchedWrite batchedWrite = this.myWrite.build();
            List<BatchedWrite.Bundle> list = batchedWrite.toBundles(this.myCollection.getName(), clusterStats.getSmallestMaxBsonObjectSize(), clusterStats.getSmallestMaxBatchedWriteOperations());
            if (!list.isEmpty()) {
                BatchedWriteCallback batchedWriteCallback = new BatchedWriteCallback(this.myCollection.getDatabaseName(), this.myCollection.getName(), this.myRealCallbacks, batchedWrite, list);
                this.myResults.add(batchedWriteCallback);
            }
            this.myWrite.reset();
            this.myWrite.setMode(this.myCollection.getMode());
            this.myRealCallbacks.clear();
        }

        private Callback<Reply> extractCallback(Object[] objectArray) {
            Object object = objectArray[objectArray.length - 1];
            if (object instanceof AbstractReplyCallback) {
                return (AbstractReplyCallback)objectArray[2];
            }
            return null;
        }

        private List<Object> optimize(BatchedAsyncMongoCollectionImpl batchedAsyncMongoCollectionImpl) {
            boolean bl;
            if (this.mySendArgs.isEmpty()) {
                return Collections.emptyList();
            }
            ClusterStats clusterStats = this.myRealClient.getClusterStats();
            Version version = clusterStats.getServerVersionRange().getLowerBounds();
            boolean bl2 = bl = BATCH_WRITE_VERSION.compareTo(version) <= 0;
            if (bl) {
                this.myCollection = batchedAsyncMongoCollectionImpl;
                this.myWrite.reset();
                this.myWrite.setMode(batchedAsyncMongoCollectionImpl.getMode());
                this.myResults = new ArrayList<Object>(this.mySendArgs.size());
                this.myRealCallbacks = new ArrayList<Callback<Reply>>(this.mySendArgs.size());
                while (!this.mySendArgs.isEmpty()) {
                    Object[] objectArray = this.mySendArgs.remove(0);
                    if (objectArray[0] instanceof Insert) {
                        this.addInsert((Insert)objectArray[0], objectArray);
                    } else if (batchedAsyncMongoCollectionImpl.isBatchUpdates() && objectArray[0] instanceof Update) {
                        this.addUpdate((Update)objectArray[0], objectArray);
                    } else if (batchedAsyncMongoCollectionImpl.isBatchDeletes() && objectArray[0] instanceof Delete) {
                        this.addDelete((Delete)objectArray[0], objectArray);
                    } else {
                        this.closeBatch();
                        this.myResults.add(objectArray);
                    }
                    if (batchedAsyncMongoCollectionImpl.getMode() != BatchedWriteMode.SERIALIZE_AND_STOP) continue;
                    this.closeBatch();
                }
                this.closeBatch();
            } else {
                this.myResults = new ArrayList<Object>(this.mySendArgs.size());
                this.myResults.addAll(this.mySendArgs);
                this.mySendArgs.clear();
            }
            return this.myResults;
        }

        private void updateDurability(Object[] objectArray) {
            Durability durability = this.myWrite.getDurability();
            if (objectArray.length == 3 && objectArray[1] instanceof GetLastError) {
                GetLastError getLastError = (GetLastError)objectArray[1];
                Durability durability2 = Durability.valueOf(getLastError.getQuery().toString());
                if (durability == null) {
                    durability = durability2;
                    this.myWrite.setDurability(durability);
                } else if (!(durability2.equals(durability) || durability2.equals(Durability.ACK) || durability2.equals(Durability.NONE))) {
                    this.closeBatch();
                    durability = durability2;
                    this.myWrite.setDurability(durability);
                }
            }
        }
    }
}

