/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.LambdaCallback;
import com.allanbank.mongodb.ListenableFuture;
import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.MongoClient;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ProfilingStatus;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.FutureCallback;
import com.allanbank.mongodb.client.LambdaCallbackAdapter;
import com.allanbank.mongodb.client.NamedReference;
import com.allanbank.mongodb.client.SynchronousMongoCollectionImpl;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.callback.CursorCallback;
import com.allanbank.mongodb.client.callback.ReplyCommandCallback;
import com.allanbank.mongodb.client.message.Command;
import com.allanbank.mongodb.client.message.Query;
import com.allanbank.mongodb.util.FutureUtils;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MongoDatabaseImpl
implements MongoDatabase {
    public static final Document EMPTY_QUERY = MongoCollection.ALL;
    protected final Client myClient;
    private MongoDatabase myAdminDatabase;
    private final ConcurrentMap<String, Reference<MongoCollection>> myCollections;
    private Durability myDurability;
    private final MongoClient myMongoClient;
    private final String myName;
    private ReadPreference myReadPreference;
    private final ReferenceQueue<MongoCollection> myReferenceQueue = new ReferenceQueue();

    public MongoDatabaseImpl(MongoClient mongoClient, Client client, String string) {
        this.myMongoClient = mongoClient;
        this.myClient = client;
        this.myName = string;
        this.myDurability = null;
        this.myReadPreference = null;
        this.myCollections = new ConcurrentHashMap<String, Reference<MongoCollection>>();
    }

    @Override
    public boolean createCappedCollection(String string, long l) throws MongoDbException {
        return this.createCollection(string, BuilderFactory.start().add("capped", true).add("size", l));
    }

    @Override
    public boolean createCollection(String string, DocumentAssignable documentAssignable) throws MongoDbException {
        Document document = this.runCommand("create", string, documentAssignable);
        NumericElement numericElement = document.get(NumericElement.class, "ok");
        return numericElement != null && numericElement.getIntValue() > 0;
    }

    @Override
    public boolean drop() {
        Document document = this.runCommand("dropDatabase");
        NumericElement numericElement = document.get(NumericElement.class, "ok");
        return numericElement != null && numericElement.getIntValue() > 0;
    }

    @Override
    public boolean exists() {
        return this.myMongoClient.listDatabaseNames().contains(this.getName());
    }

    @Override
    public MongoCollection getCollection(String string) {
        MongoCollection mongoCollection;
        Reference reference;
        MongoCollection mongoCollection2 = null;
        NamedReference<MongoCollection> namedReference = (NamedReference<MongoCollection>)this.myCollections.get(string);
        if (namedReference != null && (mongoCollection2 = (MongoCollection)namedReference.get()) == null) {
            this.myCollections.remove(string, namedReference);
        }
        if (mongoCollection2 == null && (reference = (Reference)this.myCollections.putIfAbsent(string, namedReference = new NamedReference<MongoCollection>(string, mongoCollection2 = new SynchronousMongoCollectionImpl(this.myClient, this, string), this.myReferenceQueue))) != null && (mongoCollection = (MongoCollection)reference.get()) != null) {
            mongoCollection2 = mongoCollection;
        }
        while ((reference = this.myReferenceQueue.poll()) != null) {
            if (!(reference instanceof NamedReference)) continue;
            this.myCollections.remove(((NamedReference)reference).getName(), reference);
        }
        return mongoCollection2;
    }

    @Override
    public Durability getDurability() {
        Durability durability = this.myDurability;
        if (durability == null) {
            durability = this.myClient.getDefaultDurability();
        }
        return durability;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public ProfilingStatus getProfilingStatus() throws MongoDbException {
        ProfilingStatus.Level level;
        Document document = this.runCommand("profile", -1, null);
        NumericElement numericElement = document.get(NumericElement.class, "was");
        NumericElement numericElement2 = document.get(NumericElement.class, "slowms");
        if (numericElement != null && numericElement2 != null && (level = ProfilingStatus.Level.fromValue(numericElement.getIntValue())) != null) {
            switch (level) {
                case NONE: {
                    return ProfilingStatus.OFF;
                }
                case ALL: {
                    return ProfilingStatus.ON;
                }
                case SLOW_ONLY: {
                    return ProfilingStatus.slow(numericElement2.getIntValue());
                }
            }
        }
        return null;
    }

    @Override
    public ReadPreference getReadPreference() {
        ReadPreference readPreference = this.myReadPreference;
        if (readPreference == null) {
            readPreference = this.myClient.getDefaultReadPreference();
        }
        return readPreference;
    }

    @Override
    public List<String> listCollectionNames() {
        Query query = new Query(this.myName, "system.namespaces", EMPTY_QUERY, null, 0, 0, 0, false, ReadPreference.PRIMARY, false, false, false, false);
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>(this.getLockType());
        CursorCallback cursorCallback = new CursorCallback(this.myClient, query, false, futureCallback);
        this.myClient.send(query, cursorCallback);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = FutureUtils.unwrap(futureCallback);
        while (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            for (StringElement stringElement : document.find(StringElement.class, "name")) {
                String string = stringElement.getValue();
                if (string.indexOf(36) >= 0 && string.indexOf(".oplog.$") < 0) continue;
                arrayList.add(string.substring(this.myName.length() + 1));
            }
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public List<String> listCollections() {
        return this.listCollectionNames();
    }

    @Override
    public Document runAdminCommand(String string) throws MongoDbException {
        return this.getAdminDatabase().runCommand(string);
    }

    @Override
    public Document runAdminCommand(String string, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.getAdminDatabase().runCommand(string, documentAssignable);
    }

    @Override
    public Document runAdminCommand(String string, String string2, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.getAdminDatabase().runCommand(string, string2, documentAssignable);
    }

    @Override
    public Document runCommand(DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.runCommandAsync(documentAssignable));
    }

    @Override
    public Document runCommand(String string) throws MongoDbException {
        return FutureUtils.unwrap(this.runCommandAsync(string, null));
    }

    @Override
    public Document runCommand(String string, DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.runCommandAsync(string, documentAssignable));
    }

    @Override
    public Document runCommand(String string, int n, DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.runCommandAsync(string, n, documentAssignable));
    }

    @Override
    public Document runCommand(String string, String string2, DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.runCommandAsync(string, string2, documentAssignable));
    }

    @Override
    public void runCommandAsync(Callback<Document> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.runCommandAsync(callback, documentAssignable, null);
    }

    @Override
    public void runCommandAsync(Callback<Document> callback, DocumentAssignable documentAssignable, Version version) throws MongoDbException {
        Command command = new Command(this.myName, "$cmd", documentAssignable.asDocument(), ReadPreference.PRIMARY, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyCommandCallback(callback));
    }

    @Override
    public void runCommandAsync(Callback<Document> callback, String string) throws MongoDbException {
        this.runCommandAsync(callback, string, null);
    }

    @Override
    public void runCommandAsync(Callback<Document> callback, String string, DocumentAssignable documentAssignable) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addInteger(string, 1);
        this.addOptions(string, documentAssignable, documentBuilder);
        this.runCommandAsync(callback, (DocumentAssignable)documentBuilder);
    }

    @Override
    public void runCommandAsync(Callback<Document> callback, String string, int n, DocumentAssignable documentAssignable) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add(string, n);
        this.addOptions(string, documentAssignable, documentBuilder);
        this.runCommandAsync(callback, (DocumentAssignable)documentBuilder);
    }

    @Override
    public void runCommandAsync(Callback<Document> callback, String string, String string2, DocumentAssignable documentAssignable) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add(string, string2);
        this.addOptions(string, documentAssignable, documentBuilder);
        this.runCommandAsync(callback, (DocumentAssignable)documentBuilder);
    }

    @Override
    public ListenableFuture<Document> runCommandAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.runCommandAsync(futureCallback, documentAssignable);
        return futureCallback;
    }

    @Override
    public void runCommandAsync(LambdaCallback<Document> lambdaCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.runCommandAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), documentAssignable);
    }

    @Override
    public void runCommandAsync(LambdaCallback<Document> lambdaCallback, DocumentAssignable documentAssignable, Version version) throws MongoDbException {
        this.runCommandAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), documentAssignable, version);
    }

    @Override
    public void runCommandAsync(LambdaCallback<Document> lambdaCallback, String string) throws MongoDbException {
        this.runCommandAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), string);
    }

    @Override
    public void runCommandAsync(LambdaCallback<Document> lambdaCallback, String string, DocumentAssignable documentAssignable) throws MongoDbException {
        this.runCommandAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), string, documentAssignable);
    }

    @Override
    public void runCommandAsync(LambdaCallback<Document> lambdaCallback, String string, int n, DocumentAssignable documentAssignable) throws MongoDbException {
        this.runCommandAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), string, n, documentAssignable);
    }

    @Override
    public void runCommandAsync(LambdaCallback<Document> lambdaCallback, String string, String string2, DocumentAssignable documentAssignable) throws MongoDbException {
        this.runCommandAsync(new LambdaCallbackAdapter<Document>(lambdaCallback), string, string2, documentAssignable);
    }

    @Override
    public ListenableFuture<Document> runCommandAsync(String string) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.runCommandAsync(futureCallback, string, null);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> runCommandAsync(String string, DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.runCommandAsync(futureCallback, string, documentAssignable);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> runCommandAsync(String string, int n, DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.runCommandAsync(futureCallback, string, n, documentAssignable);
        return futureCallback;
    }

    @Override
    public ListenableFuture<Document> runCommandAsync(String string, String string2, DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        this.runCommandAsync(futureCallback, string, string2, documentAssignable);
        return futureCallback;
    }

    @Override
    public void setDurability(Durability durability) {
        this.myDurability = durability;
    }

    @Override
    public boolean setProfilingStatus(ProfilingStatus profilingStatus) throws MongoDbException {
        ProfilingStatus.Level level;
        Document document = this.runCommand("profile", profilingStatus.getLevel().getValue(), (DocumentAssignable)BuilderFactory.start().add("slowms", profilingStatus.getSlowMillisThreshold()));
        NumericElement numericElement = document.get(NumericElement.class, "was");
        NumericElement numericElement2 = document.get(NumericElement.class, "slowms");
        if (numericElement != null && numericElement2 != null && (level = ProfilingStatus.Level.fromValue(numericElement.getIntValue())) != null) {
            switch (level) {
                case NONE: {
                    return !ProfilingStatus.Level.NONE.equals((Object)profilingStatus.getLevel());
                }
                case ALL: {
                    return !ProfilingStatus.Level.ALL.equals((Object)profilingStatus.getLevel());
                }
                case SLOW_ONLY: {
                    ProfilingStatus profilingStatus2 = ProfilingStatus.slow(numericElement2.getIntValue());
                    return !profilingStatus2.equals(profilingStatus);
                }
            }
        }
        return true;
    }

    @Override
    public void setReadPreference(ReadPreference readPreference) {
        this.myReadPreference = readPreference;
    }

    @Override
    public Document stats() throws MongoDbException {
        return this.runCommand("dbStats");
    }

    protected void addOptions(String string, DocumentAssignable documentAssignable, DocumentBuilder documentBuilder) {
        if (documentAssignable != null) {
            for (Element element : documentAssignable.asDocument()) {
                if (string.equals(element.getName())) continue;
                documentBuilder.add(element);
            }
        }
    }

    protected LockType getLockType() {
        return this.myClient.getConfig().getLockType();
    }

    private MongoDatabase getAdminDatabase() {
        if (this.myAdminDatabase == null) {
            this.myAdminDatabase = this.myName.equals("admin") ? this : this.myMongoClient.getDatabase("admin");
        }
        return this.myAdminDatabase;
    }
}

