/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.callback.FutureReplyCallback;
import com.allanbank.mongodb.client.message.CursorableMessage;
import com.allanbank.mongodb.client.message.GetMore;
import com.allanbank.mongodb.client.message.KillCursors;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.error.CursorNotFoundException;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MongoIteratorImpl
implements MongoIterator<Document> {
    private static final Log LOG = LogFactory.getLog(MongoIteratorImpl.class);
    private int myBatchSize = 0;
    private final Client myClient;
    private final String myCollectionName;
    private Iterator<Document> myCurrentIterator;
    private long myCursorId = 0L;
    private final String myDatabaseName;
    private int myLimit = 0;
    private FutureReplyCallback myNextReply;
    private final ReadPreference myReadPerference;
    private boolean myShutdown = false;

    public MongoIteratorImpl(CursorableMessage cursorableMessage, Client client, String string, Reply reply) {
        this.myNextReply = new FutureReplyCallback();
        this.myNextReply.callback(reply);
        this.myReadPerference = ReadPreference.server(string);
        this.myCursorId = 0L;
        this.myClient = client;
        this.myCurrentIterator = null;
        this.myBatchSize = cursorableMessage.getBatchSize();
        this.myLimit = cursorableMessage.getLimit();
        this.myDatabaseName = cursorableMessage.getDatabaseName();
        this.myCollectionName = cursorableMessage.getCollectionName();
    }

    public MongoIteratorImpl(Document document, Client client) {
        String string;
        String string2 = string = document.get(StringElement.class, "ns").getValue();
        String string3 = string;
        int n = string.indexOf(46);
        if (0 < n) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        this.myClient = client;
        this.myDatabaseName = string2;
        this.myCollectionName = string3;
        this.myCursorId = document.get(NumericElement.class, "cursor_id").getLongValue();
        this.myLimit = document.get(NumericElement.class, "limit").getIntValue();
        this.myBatchSize = document.get(NumericElement.class, "batch_size").getIntValue();
        this.myReadPerference = ReadPreference.server(document.get(StringElement.class, "server").getValue());
    }

    @Override
    public Document asDocument() {
        long l = this.myCursorId;
        FutureReplyCallback futureReplyCallback = this.myNextReply;
        if ((l = this.retreiveCursorIdFromPendingRequest(l, futureReplyCallback)) != 0L) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.add("ns", this.myDatabaseName + "." + this.myCollectionName);
            documentBuilder.add("cursor_id", l);
            documentBuilder.add("server", this.myReadPerference.getServer());
            documentBuilder.add("limit", this.myLimit);
            documentBuilder.add("batch_size", this.myBatchSize);
            return documentBuilder.build();
        }
        return null;
    }

    @Override
    public void close() {
        long l = this.myCursorId;
        FutureReplyCallback futureReplyCallback = this.myNextReply;
        this.myCurrentIterator = null;
        this.myNextReply = null;
        this.myCursorId = 0L;
        if ((l = this.retreiveCursorIdFromPendingRequest(l, futureReplyCallback)) != 0L && !this.myShutdown) {
            this.myClient.send(new KillCursors(new long[]{l}, this.myReadPerference), null);
        }
    }

    @Override
    public int getBatchSize() {
        return this.myBatchSize;
    }

    public ReadPreference getReadPerference() {
        return this.myReadPerference;
    }

    @Override
    public boolean hasNext() {
        if (this.myCurrentIterator == null) {
            this.loadDocuments();
        } else if (!this.myCurrentIterator.hasNext() && this.myNextReply != null) {
            this.loadDocuments();
        }
        return this.myCurrentIterator.hasNext();
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }

    @Override
    public Document next() {
        if (this.hasNext()) {
            return this.myCurrentIterator.next();
        }
        throw new NoSuchElementException("No more documents.");
    }

    public int nextBatchSize() {
        if (0 < this.myLimit && this.myLimit <= this.myBatchSize) {
            return this.myLimit;
        }
        return this.myBatchSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove a document via a MongoDB iterator.");
    }

    public void restart() throws MongoDbException {
        this.sendRequest();
    }

    @Override
    public void setBatchSize(int n) {
        this.myBatchSize = n;
    }

    @Override
    public void stop() {
        this.myShutdown = true;
    }

    @Override
    public Object[] toArray() {
        List<Document> list = this.toList();
        return list.toArray();
    }

    @Override
    public <S> S[] toArray(S[] SArray) {
        List<Document> list = this.toList();
        return list.toArray(SArray);
    }

    @Override
    public List<Document> toList() {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        return arrayList;
    }

    protected Client getClient() {
        return this.myClient;
    }

    protected String getCollectionName() {
        return this.myCollectionName;
    }

    protected long getCursorId() {
        return this.myCursorId;
    }

    protected String getDatabaseName() {
        return this.myDatabaseName;
    }

    protected int getLimit() {
        return this.myLimit;
    }

    protected void loadDocuments() throws RuntimeException {
        this.loadDocuments(true);
    }

    protected List<Document> loadDocuments(boolean bl) throws RuntimeException {
        List<Document> list;
        try {
            Reply reply = (Reply)this.myNextReply.get();
            if (reply.isCursorNotFound() || reply.isQueryFailed()) {
                long l = this.myCursorId;
                this.myCursorId = 0L;
                throw new CursorNotFoundException(reply, "Cursor id (" + l + ") not found by the MongoDB server.");
            }
            this.myCursorId = reply.getCursorId();
            list = reply.getResults();
            this.myCurrentIterator = list.iterator();
            if (0 < this.myLimit) {
                if (this.myLimit <= list.size()) {
                    this.myCurrentIterator = list.subList(0, this.myLimit).iterator();
                    if (this.myCursorId != 0L) {
                        this.myClient.send(new KillCursors(new long[]{this.myCursorId}, this.myReadPerference), null);
                        this.myCursorId = 0L;
                    }
                }
                this.myLimit -= list.size();
            }
            if (this.myCursorId != 0L && !this.myShutdown) {
                this.sendRequest();
                while (list.isEmpty() && bl && this.myNextReply != null) {
                    list = this.loadDocuments(false);
                }
            } else {
                this.myNextReply = null;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        return list;
    }

    protected long retreiveCursorIdFromPendingRequest(long l, Future<Reply> future) {
        if (l == 0L && future != null) {
            try {
                Reply reply = future.get();
                return reply.getCursorId();
            }
            catch (InterruptedException interruptedException) {
                LOG.warn(interruptedException, "Interrupted waiting for a query reply: {}", interruptedException.getMessage());
            }
            catch (ExecutionException executionException) {
                LOG.warn(executionException, "Interrupted waiting for a query reply: {}", executionException.getMessage());
            }
        }
        return l;
    }

    protected void sendRequest() throws MongoDbException {
        GetMore getMore = new GetMore(this.myDatabaseName, this.myCollectionName, this.myCursorId, this.nextBatchSize(), this.myReadPerference);
        this.myNextReply = new FutureReplyCallback();
        this.myClient.send(getMore, this.myNextReply);
    }
}

