/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.BatchedAsyncMongoCollection;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.ListenableFuture;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.Count;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.ParallelScan;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import com.allanbank.mongodb.client.AbstractAsyncMongoCollection;
import com.allanbank.mongodb.client.BatchedAsyncMongoCollectionImpl;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.FutureCallback;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.callback.FutureReplyCallback;
import com.allanbank.mongodb.client.callback.ValidatingReplyCallback;
import com.allanbank.mongodb.client.message.CreateIndexCommand;
import com.allanbank.mongodb.util.FutureUtils;
import java.util.Collection;
import java.util.List;

public class SynchronousMongoCollectionImpl
extends AbstractAsyncMongoCollection
implements MongoCollection {
    public SynchronousMongoCollectionImpl(Client client, MongoDatabase mongoDatabase, String string) {
        super(client, mongoDatabase, string);
    }

    @Override
    public MongoIterator<Document> aggregate(Aggregate aggregate) throws MongoDbException {
        return FutureUtils.unwrap(this.aggregateAsync(aggregate));
    }

    @Override
    public MongoIterator<Document> aggregate(Aggregate.Builder builder) throws MongoDbException {
        return this.aggregate(builder.build());
    }

    @Override
    public long count() throws MongoDbException {
        return this.count(BuilderFactory.start(), this.getReadPreference());
    }

    @Override
    public long count(Count count) throws MongoDbException {
        ListenableFuture<Long> listenableFuture = this.countAsync(count);
        return FutureUtils.unwrap(listenableFuture);
    }

    @Override
    public long count(Count.Builder builder) throws MongoDbException {
        return this.count(builder.build());
    }

    @Override
    public long count(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.count(documentAssignable, this.getReadPreference());
    }

    @Override
    public long count(DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        ListenableFuture<Long> listenableFuture = this.countAsync(documentAssignable, readPreference);
        return FutureUtils.unwrap(listenableFuture);
    }

    @Override
    public long count(ReadPreference readPreference) throws MongoDbException {
        return this.count(BuilderFactory.start(), readPreference);
    }

    @Override
    public void createIndex(boolean bl, Element ... elementArray) throws MongoDbException {
        this.createIndex(null, bl, elementArray);
    }

    @Override
    public void createIndex(DocumentAssignable documentAssignable, Element ... elementArray) throws MongoDbException {
        this.createIndex(null, documentAssignable, elementArray);
    }

    @Override
    public void createIndex(Element ... elementArray) throws MongoDbException {
        this.createIndex(EMPTY_INDEX_OPTIONS, elementArray);
    }

    @Override
    public void createIndex(String string, boolean bl, Element ... elementArray) throws MongoDbException {
        this.createIndex(string, bl ? UNIQUE_INDEX_OPTIONS : EMPTY_INDEX_OPTIONS, elementArray);
    }

    @Override
    public void createIndex(String string, DocumentAssignable documentAssignable, Element ... elementArray) throws MongoDbException {
        if (this.isCreateIndexesSupported()) {
            CreateIndexCommand createIndexCommand = new CreateIndexCommand(this.getDatabaseName(), this.getName(), elementArray, string, documentAssignable);
            FutureReplyCallback futureReplyCallback = new FutureReplyCallback();
            this.myClient.send(createIndexCommand, new ValidatingReplyCallback(futureReplyCallback));
            FutureUtils.unwrap(futureReplyCallback);
        } else {
            String string2 = string;
            if (string == null || string.isEmpty()) {
                string2 = CreateIndexCommand.buildIndexName(elementArray);
            }
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.addString("name", string2);
            documentBuilder.addString("ns", this.getDatabaseName() + "." + this.getName());
            DocumentBuilder documentBuilder2 = documentBuilder.push("key");
            for (Element object : elementArray) {
                documentBuilder2.add(object);
            }
            for (Element element : documentAssignable.asDocument()) {
                documentBuilder.add(element);
            }
            SynchronousMongoCollectionImpl synchronousMongoCollectionImpl = new SynchronousMongoCollectionImpl(this.myClient, this.myDatabase, "system.indexes");
            Document document = documentBuilder.build();
            if (synchronousMongoCollectionImpl.findOne(document) == null) {
                Version version = this.determineIndexServerVersion(elementArray);
                FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
                synchronousMongoCollectionImpl.doInsertAsync(futureCallback, false, Durability.ACK, version, document);
                FutureUtils.unwrap(futureCallback);
            }
        }
    }

    @Override
    public long delete(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.delete(documentAssignable, false, this.getDurability());
    }

    @Override
    public long delete(DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        return this.delete(documentAssignable, bl, this.getDurability());
    }

    @Override
    public long delete(DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        ListenableFuture<Long> listenableFuture = this.deleteAsync(documentAssignable, bl, durability);
        return FutureUtils.unwrap(listenableFuture);
    }

    @Override
    public long delete(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        return this.delete(documentAssignable, false, durability);
    }

    @Override
    public MongoIterator<Element> distinct(Distinct distinct) throws MongoDbException {
        return FutureUtils.unwrap(this.distinctAsync(distinct));
    }

    @Override
    public MongoIterator<Element> distinct(Distinct.Builder builder) throws MongoDbException {
        return this.distinct(builder.build());
    }

    @Override
    public boolean drop() {
        Document document = this.myDatabase.runCommand("drop", this.myName, null);
        List<NumericElement> list = document.find(NumericElement.class, "ok");
        return list.size() > 0 && list.get(0).getIntValue() > 0;
    }

    @Override
    public boolean dropIndex(IntegerElement ... integerElementArray) throws MongoDbException {
        return this.dropIndex(CreateIndexCommand.buildIndexName(integerElementArray));
    }

    @Override
    public boolean dropIndex(String string) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("index", string);
        Document document = this.myDatabase.runCommand("deleteIndexes", this.myName, (DocumentAssignable)documentBuilder.build());
        List<NumericElement> list = document.find(NumericElement.class, "ok");
        return list.size() > 0 && list.get(0).getIntValue() > 0;
    }

    @Override
    public boolean exists() throws MongoDbException {
        return this.myDatabase.listCollectionNames().contains(this.getName());
    }

    @Override
    public Document explain(Aggregate aggregate) throws MongoDbException {
        return FutureUtils.unwrap(this.explainAsync(aggregate));
    }

    @Override
    public Document explain(Aggregate.Builder builder) throws MongoDbException {
        return FutureUtils.unwrap(this.explainAsync(builder.build()));
    }

    @Override
    public Document explain(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.explain(new Find.Builder(documentAssignable).build());
    }

    @Override
    public Document explain(Find find) throws MongoDbException {
        return FutureUtils.unwrap(this.explainAsync(find));
    }

    @Override
    public Document explain(Find.Builder builder) throws MongoDbException {
        return this.explain(builder.build());
    }

    @Override
    public MongoIterator<Document> find(DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.findAsync(documentAssignable));
    }

    @Override
    public MongoIterator<Document> find(Find find) throws MongoDbException {
        return FutureUtils.unwrap(this.findAsync(find));
    }

    @Override
    public MongoIterator<Document> find(Find.Builder builder) throws MongoDbException {
        return this.find(builder.build());
    }

    @Override
    public Document findAndModify(FindAndModify findAndModify) throws MongoDbException {
        return FutureUtils.unwrap(this.findAndModifyAsync(findAndModify));
    }

    @Override
    public Document findAndModify(FindAndModify.Builder builder) throws MongoDbException {
        return this.findAndModify(builder.build());
    }

    @Override
    public Document findOne(DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.findOneAsync(documentAssignable));
    }

    @Override
    public Document findOne(Find find) throws MongoDbException {
        return FutureUtils.unwrap(this.findOneAsync(find));
    }

    @Override
    public Document findOne(Find.Builder builder) throws MongoDbException {
        return this.findOne(builder.build());
    }

    @Override
    public MongoIterator<Element> groupBy(GroupBy groupBy) throws MongoDbException {
        return FutureUtils.unwrap(this.groupByAsync(groupBy));
    }

    @Override
    public MongoIterator<Element> groupBy(GroupBy.Builder builder) throws MongoDbException {
        return this.groupBy(builder.build());
    }

    @Override
    public int insert(boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        return this.insert(bl, this.getDurability(), documentAssignableArray);
    }

    @Override
    public int insert(boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        ListenableFuture<Integer> listenableFuture = this.insertAsync(bl, durability, documentAssignableArray);
        return FutureUtils.unwrap(listenableFuture);
    }

    @Override
    public int insert(DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        return this.insert(false, this.getDurability(), documentAssignableArray);
    }

    @Override
    public int insert(Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        return this.insert(false, durability, documentAssignableArray);
    }

    @Override
    public boolean isCapped() throws MongoDbException {
        Document document = this.stats();
        NumericElement numericElement = document.get(NumericElement.class, "capped");
        if (numericElement != null) {
            return numericElement.getIntValue() != 0;
        }
        BooleanElement booleanElement = document.get(BooleanElement.class, "capped");
        if (booleanElement != null) {
            return booleanElement.getValue();
        }
        return false;
    }

    @Override
    public MongoIterator<Document> mapReduce(MapReduce mapReduce) throws MongoDbException {
        return FutureUtils.unwrap(this.mapReduceAsync(mapReduce));
    }

    @Override
    public MongoIterator<Document> mapReduce(MapReduce.Builder builder) throws MongoDbException {
        return this.mapReduce(builder.build());
    }

    @Override
    public Collection<MongoIterator<Document>> parallelScan(ParallelScan parallelScan) throws MongoDbException {
        return FutureUtils.unwrap(this.parallelScanAsync(parallelScan));
    }

    @Override
    public Collection<MongoIterator<Document>> parallelScan(ParallelScan.Builder builder) throws MongoDbException {
        return this.parallelScan(builder.build());
    }

    @Override
    public int save(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.save(documentAssignable, this.getDurability());
    }

    @Override
    public int save(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        return FutureUtils.unwrap(this.saveAsync(documentAssignable, durability));
    }

    @Override
    public BatchedAsyncMongoCollection startBatch() {
        return new BatchedAsyncMongoCollectionImpl(this.myClient, this.myDatabase, this.myName);
    }

    @Override
    public Document stats() throws MongoDbException {
        return this.myDatabase.runCommand("collStats", this.getName(), null);
    }

    @Override
    @Deprecated
    public MongoIterator<TextResult> textSearch(Text text) throws MongoDbException {
        return FutureUtils.unwrap(this.textSearchAsync(text));
    }

    @Override
    @Deprecated
    public MongoIterator<TextResult> textSearch(Text.Builder builder) throws MongoDbException {
        return this.textSearch(builder.build());
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        return this.update(documentAssignable, documentAssignable2, false, false, this.getDurability());
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        return this.update(documentAssignable, documentAssignable2, bl, bl2, this.getDurability());
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        ListenableFuture<Long> listenableFuture = this.updateAsync(documentAssignable, documentAssignable2, bl, bl2, durability);
        return FutureUtils.unwrap(listenableFuture);
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        return this.update(documentAssignable, documentAssignable2, false, false, durability);
    }

    @Override
    public Document updateOptions(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>(this.getLockType());
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("collMod", this.getName());
        this.addOptions("collMod", documentAssignable, documentBuilder);
        this.myDatabase.runCommandAsync(futureCallback, (DocumentAssignable)documentBuilder.build(), Version.VERSION_2_2);
        return FutureUtils.unwrap(futureCallback);
    }

    @Override
    public Document validate(MongoCollection.ValidateMode validateMode) throws MongoDbException {
        Document document = null;
        switch (validateMode) {
            case INDEX_ONLY: {
                document = this.myDatabase.runCommand("validate", this.getName(), (DocumentAssignable)BuilderFactory.start().add("scandata", false).build());
                break;
            }
            case NORMAL: {
                document = this.myDatabase.runCommand("validate", this.getName(), null);
                break;
            }
            case FULL: {
                document = this.myDatabase.runCommand("validate", this.getName(), (DocumentAssignable)BuilderFactory.start().add("full", true).build());
            }
        }
        return document;
    }

    @Override
    public long write(BatchedWrite batchedWrite) throws MongoDbException {
        ListenableFuture<Long> listenableFuture = this.writeAsync(batchedWrite);
        return FutureUtils.unwrap(listenableFuture);
    }

    @Override
    public long write(BatchedWrite.Builder builder) throws MongoDbException {
        return this.write(builder.build());
    }

    protected void addOptions(String string, DocumentAssignable documentAssignable, DocumentBuilder documentBuilder) {
        if (documentAssignable != null) {
            for (Element element : documentAssignable.asDocument()) {
                if (string.equals(element.getName())) continue;
                documentBuilder.add(element);
            }
        }
    }

    protected Version determineIndexServerVersion(Element[] elementArray) {
        Version version = null;
        for (Element element : elementArray) {
            if (element.getType() != ElementType.STRING) continue;
            String string = element.getValueAsString();
            if ("2dsphere".equals(string)) {
                version = Version.later(version, Version.VERSION_2_4);
                continue;
            }
            if ("hashed".equals(string)) {
                version = Version.later(version, Version.VERSION_2_4);
                continue;
            }
            if (!"text".equals(string)) continue;
            version = Version.later(version, Version.VERSION_2_4);
        }
        return version;
    }

    protected boolean isCreateIndexesSupported() {
        ClusterStats clusterStats = this.myClient.getClusterStats();
        VersionRange versionRange = clusterStats.getServerVersionRange();
        Version version = versionRange.getLowerBounds();
        return CreateIndexCommand.REQUIRED_VERSION.compareTo(version) <= 0;
    }
}

