/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.client.message.Reply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandCursorTranslator {
    static Reply translate(Reply reply) {
        Reply reply2 = reply;
        List<Reply> list = CommandCursorTranslator.translateAll(reply);
        if (list.size() == 1) {
            reply2 = list.get(0);
        }
        return reply2;
    }

    static List<Reply> translateAll(Reply reply) {
        List<Reply> list = Collections.singletonList(reply);
        List<Document> list2 = reply.getResults();
        if (list2.size() == 1) {
            Document document = list2.get(0);
            ArrayElement arrayElement = document.get(ArrayElement.class, "result");
            if (arrayElement != null) {
                List<DocumentElement> list3 = document.find(DocumentElement.class, "result", ".*");
                list = Collections.singletonList(CommandCursorTranslator.translate(reply, 0L, list3));
            } else {
                DocumentElement documentElement = document.get(DocumentElement.class, "cursor");
                if (documentElement != null) {
                    list = CommandCursorTranslator.translate(reply, Collections.singletonList(documentElement));
                } else {
                    List<DocumentElement> list4 = document.find(DocumentElement.class, "cursors", ".*", "cursor");
                    if (!list4.isEmpty()) {
                        list = CommandCursorTranslator.translate(reply, list4);
                    }
                }
            }
        }
        return list;
    }

    private static List<Reply> translate(Reply reply, List<DocumentElement> list) {
        ArrayList<Reply> arrayList = new ArrayList<Reply>(list.size());
        for (DocumentElement documentElement : list) {
            NumericElement numericElement = documentElement.get(NumericElement.class, "id");
            List<DocumentElement> list2 = documentElement.find(DocumentElement.class, "firstBatch", ".*");
            arrayList.add(CommandCursorTranslator.translate(reply, numericElement == null ? 0L : numericElement.getLongValue(), list2));
        }
        return arrayList;
    }

    private static Reply translate(Reply reply, long l, List<DocumentElement> list) {
        ArrayList<Document> arrayList = new ArrayList<Document>(list.size());
        for (DocumentElement documentElement : list) {
            arrayList.add(BuilderFactory.start((DocumentAssignable)documentElement).build());
        }
        return new Reply(reply.getResponseToId(), l, reply.getCursorOffset(), arrayList, reply.isAwaitCapable(), reply.isCursorNotFound(), reply.isQueryFailed(), reply.isShardConfigStale());
    }

    private CommandCursorTranslator() {
    }
}

