/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.MongoIteratorImpl;
import com.allanbank.mongodb.client.callback.AbstractReplyCallback;
import com.allanbank.mongodb.client.callback.AddressAware;
import com.allanbank.mongodb.client.callback.CommandCursorTranslator;
import com.allanbank.mongodb.client.message.CursorableMessage;
import com.allanbank.mongodb.client.message.Reply;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MultipleCursorCallback
extends AbstractReplyCallback<Collection<MongoIterator<Document>>>
implements AddressAware {
    private volatile String myAddress;
    private final Client myClient;
    private final CursorableMessage myMessage;
    private volatile Reply myReply;
    private final AtomicBoolean mySetOther;

    public MultipleCursorCallback(Client client, CursorableMessage cursorableMessage, Callback<Collection<MongoIterator<Document>>> callback) {
        super(callback);
        this.myClient = client;
        this.myMessage = cursorableMessage;
        this.mySetOther = new AtomicBoolean(false);
    }

    public String getAddress() {
        return this.myAddress;
    }

    @Override
    public void setAddress(String string) {
        this.myAddress = string;
        this.trigger();
    }

    @Override
    protected MongoDbException asError(Reply reply, int n, int n2, String string) {
        return super.asError(reply, n, n2, false, string, this.myMessage);
    }

    @Override
    protected Collection<MongoIterator<Document>> convert(Reply reply) throws MongoDbException {
        List<Reply> list = CommandCursorTranslator.translateAll(reply);
        ArrayList<MongoIterator<Document>> arrayList = new ArrayList<MongoIterator<Document>>(list.size());
        for (Reply reply2 : list) {
            arrayList.add(new MongoIteratorImpl(this.myMessage, this.myClient, this.myAddress, reply2));
        }
        return arrayList;
    }

    @Override
    protected void handle(Reply reply) {
        this.myReply = reply;
        this.trigger();
    }

    private void trigger() {
        if (!this.mySetOther.compareAndSet(false, true)) {
            super.handle(this.myReply);
        }
    }
}

