/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.client.SimpleMongoIteratorImpl;
import com.allanbank.mongodb.client.callback.AbstractReplyCallback;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.Collections;
import java.util.List;

public class ReplyArrayCallback
extends AbstractReplyCallback<MongoIterator<Element>> {
    public static final String DEFAULT_NAME = "values";
    private final String myName;

    public ReplyArrayCallback(Callback<MongoIterator<Element>> callback) {
        this(DEFAULT_NAME, callback);
    }

    public ReplyArrayCallback(String string, Callback<MongoIterator<Element>> callback) {
        super(callback);
        this.myName = string;
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null) {
            List<Document> list = reply.getResults();
            if (list.size() != 1) {
                mongoDbException = new ReplyException(reply, "Should only be a single document in the reply.");
            } else if (reply.getResults().get(0).find(ArrayElement.class, this.myName).isEmpty()) {
                mongoDbException = new ReplyException(reply, "No '" + this.myName + "' array in the reply.");
            }
        }
        return mongoDbException;
    }

    @Override
    protected MongoIterator<Element> convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            List<Object> list2 = Collections.emptyList();
            Document document = list.get(0);
            ArrayElement arrayElement = document.findFirst(ArrayElement.class, this.myName);
            if (arrayElement != null) {
                list2 = arrayElement.getEntries();
            }
            return new SimpleMongoIteratorImpl<Element>(list2);
        }
        return null;
    }
}

