/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.client.callback.Receiver;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.message.Reply;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class ReplyHandler
implements Runnable {
    private static final ThreadLocal<Receiver> ourReceiver = new ThreadLocal();
    private final Throwable myError;
    private final Reply myReply;
    private final ReplyCallback myReplyCallback;

    public static void raiseError(Throwable throwable, ReplyCallback replyCallback, Executor executor) {
        if (replyCallback != null) {
            if (executor != null) {
                try {
                    executor.execute(new ReplyHandler(replyCallback, throwable));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    replyCallback.exception(throwable);
                }
            } else {
                replyCallback.exception(throwable);
            }
        }
    }

    public static void reply(Receiver receiver, Reply reply, ReplyCallback replyCallback, Executor executor) {
        if (replyCallback != null) {
            boolean bl = replyCallback.isLightWeight();
            if (!bl && executor != null) {
                try {
                    executor.execute(new ReplyHandler(replyCallback, reply));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    ReplyHandler.run(receiver, reply, replyCallback);
                }
            } else {
                ReplyHandler.run(receiver, reply, replyCallback);
            }
        }
    }

    public static void tryReceive() {
        Receiver receiver = ourReceiver.get();
        if (receiver != null) {
            receiver.tryReceive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(Receiver receiver, Reply reply, ReplyCallback replyCallback) {
        Receiver receiver2 = ourReceiver.get();
        try {
            ourReceiver.set(receiver);
            replyCallback.callback(reply);
        }
        finally {
            ourReceiver.set(receiver2);
        }
    }

    public ReplyHandler(ReplyCallback replyCallback, Reply reply) {
        this.myReplyCallback = replyCallback;
        this.myReply = reply;
        this.myError = null;
    }

    public ReplyHandler(ReplyCallback replyCallback, Throwable throwable) {
        this.myReplyCallback = replyCallback;
        this.myError = throwable;
        this.myReply = null;
    }

    @Override
    public void run() {
        if (this.myReply != null) {
            ReplyHandler.reply(null, this.myReply, this.myReplyCallback, null);
        } else if (this.myError != null) {
            ReplyHandler.raiseError(this.myError, this.myReplyCallback, null);
        }
    }
}

