/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.client.callback.AbstractReplyCallback;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

public class ReplyIntegerCallback
extends AbstractReplyCallback<Integer> {
    public static final String DEFAULT_NAME = "n";
    private final String myName;

    public ReplyIntegerCallback(Callback<Integer> callback) {
        this(DEFAULT_NAME, callback);
    }

    public ReplyIntegerCallback(String string, Callback<Integer> callback) {
        super(callback);
        this.myName = string;
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        Document document;
        Element element;
        List<Document> list;
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null && (list = reply.getResults()).size() == 1 && this.toInt(element = (document = list.get(0)).get(this.myName)) < 0) {
            mongoDbException = new ReplyException(reply, "Missing '" + this.myName + "' field in reply.");
        }
        return mongoDbException;
    }

    @Override
    protected Integer convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            Document document = list.get(0);
            Element element = document.get(this.myName);
            return this.toInt(element);
        }
        return -1;
    }
}

