/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.auth;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.auth.AuthenticatingConnection;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;

public class AuthenticationConnectionFactory
implements ProxiedConnectionFactory {
    private final MongoClientConfiguration myConfig;
    private final ProxiedConnectionFactory myProxiedConnectionFactory;

    public AuthenticationConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myProxiedConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
    }

    @Override
    public void close() {
        IOUtils.close(this.myProxiedConnectionFactory);
    }

    @Override
    public AuthenticatingConnection connect() throws IOException {
        return new AuthenticatingConnection(this.myProxiedConnectionFactory.connect(), this.myConfig);
    }

    @Override
    public AuthenticatingConnection connect(Server server, MongoClientConfiguration mongoClientConfiguration) throws IOException {
        return new AuthenticatingConnection(this.myProxiedConnectionFactory.connect(server, mongoClientConfiguration), mongoClientConfiguration);
    }

    @Override
    public ClusterStats getClusterStats() {
        return this.myProxiedConnectionFactory.getClusterStats();
    }

    @Override
    public ClusterType getClusterType() {
        return this.myProxiedConnectionFactory.getClusterType();
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        ReconnectStrategy reconnectStrategy = this.myProxiedConnectionFactory.getReconnectStrategy();
        reconnectStrategy.setConnectionFactory(this);
        return reconnectStrategy;
    }
}

