/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.bootstrap;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.callback.FutureReplyCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ConnectionFactory;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.auth.AuthenticationConnectionFactory;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.connection.rs.ReplicaSetConnectionFactory;
import com.allanbank.mongodb.client.connection.sharded.ShardedConnectionFactory;
import com.allanbank.mongodb.client.connection.socket.SocketConnectionFactory;
import com.allanbank.mongodb.client.message.IsMaster;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.error.CannotConnectException;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public class BootstrapConnectionFactory
implements ConnectionFactory {
    protected static final Log LOG = LogFactory.getLog(BootstrapConnectionFactory.class);
    private final MongoClientConfiguration myConfig;
    private ConnectionFactory myDelegate = null;

    public BootstrapConnectionFactory(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
    }

    @Override
    public void close() {
        IOUtils.close(this.myDelegate);
    }

    @Override
    public Connection connect() throws IOException {
        return this.getDelegate().connect();
    }

    @Override
    public ClusterStats getClusterStats() {
        return this.getDelegate().getClusterStats();
    }

    @Override
    public ClusterType getClusterType() {
        return this.getDelegate().getClusterType();
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        return this.getDelegate().getReconnectStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bootstrap() {
        SocketConnectionFactory socketConnectionFactory = new SocketConnectionFactory(this.myConfig);
        ProxiedConnectionFactory proxiedConnectionFactory = socketConnectionFactory;
        if (this.myConfig.isAuthenticating()) {
            proxiedConnectionFactory = new AuthenticationConnectionFactory(proxiedConnectionFactory, this.myConfig);
        }
        try {
            Cluster cluster = socketConnectionFactory.getCluster();
            for (InetSocketAddress inetSocketAddress : this.myConfig.getServerAddresses()) {
                Connection connection = null;
                FutureReplyCallback futureReplyCallback = new FutureReplyCallback();
                try {
                    connection = proxiedConnectionFactory.connect(cluster.add(inetSocketAddress), this.myConfig);
                    connection.send(new IsMaster(), futureReplyCallback);
                    Reply reply = (Reply)futureReplyCallback.get();
                    IOUtils.close(connection);
                    List<Document> list = reply.getResults();
                    if (list.isEmpty()) continue;
                    Document document = list.get(0);
                    if (this.isMongos(document)) {
                        LOG.debug("Sharded bootstrap to {}.", inetSocketAddress);
                        cluster.clear();
                        this.myDelegate = this.bootstrapSharded(proxiedConnectionFactory);
                    } else if (this.isReplicationSet(document)) {
                        LOG.debug("Replica-set bootstrap to {}.", inetSocketAddress);
                        cluster.clear();
                        this.myDelegate = this.bootstrapReplicaSet(proxiedConnectionFactory);
                    } else {
                        LOG.debug("Simple MongoDB bootstrap to {}.", inetSocketAddress);
                        this.myDelegate = proxiedConnectionFactory;
                    }
                    proxiedConnectionFactory = null;
                    return;
                }
                catch (IOException iOException) {
                    LOG.warn(iOException, "I/O error during bootstrap to {}.", inetSocketAddress);
                }
                catch (InterruptedException interruptedException) {
                    LOG.warn(interruptedException, "Interrupted during bootstrap to {}.", inetSocketAddress);
                }
                catch (ExecutionException executionException) {
                    LOG.warn(executionException, "Error during bootstrap to {}.", inetSocketAddress);
                }
                finally {
                    IOUtils.close(connection, Level.WARNING, "I/O error shutting down bootstrap connection to " + inetSocketAddress + ".");
                }
            }
        }
        finally {
            IOUtils.close(proxiedConnectionFactory);
        }
    }

    protected ConnectionFactory bootstrapReplicaSet(ProxiedConnectionFactory proxiedConnectionFactory) {
        return new ReplicaSetConnectionFactory(proxiedConnectionFactory, this.getConfig());
    }

    protected ConnectionFactory bootstrapSharded(ProxiedConnectionFactory proxiedConnectionFactory) {
        return new ShardedConnectionFactory(proxiedConnectionFactory, this.getConfig());
    }

    protected MongoClientConfiguration getConfig() {
        return this.myConfig;
    }

    protected ConnectionFactory getDelegate() {
        if (this.myDelegate == null) {
            return this.createDelegate();
        }
        return this.myDelegate;
    }

    protected void setDelegate(ConnectionFactory connectionFactory) {
        this.myDelegate = connectionFactory;
    }

    private synchronized ConnectionFactory createDelegate() {
        if (this.myDelegate == null) {
            this.bootstrap();
            if (this.myDelegate == null) {
                LOG.warn("Could not bootstrap a connection to the MongoDB servers.");
                throw new CannotConnectException("Could not bootstrap a connection to the MongoDB servers.");
            }
        }
        return this.myDelegate;
    }

    private boolean isMongos(Document document) {
        Element element = document.get("msg");
        if (element instanceof StringElement) {
            return "isdbgrid".equals(((StringElement)element).getValue());
        }
        return false;
    }

    private boolean isReplicationSet(Document document) {
        return document.get("setName") instanceof StringElement;
    }
}

