/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.proxy;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.proxy.ConnectionInfo;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.error.ConnectionLostException;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractProxyMultipleConnection<K>
implements Connection {
    private static final Log LOG = LogFactory.getLog(AbstractProxyMultipleConnection.class);
    protected final Cluster myCluster;
    protected final MongoClientConfiguration myConfig;
    protected final PropertyChangeSupport myEventSupport;
    protected final ProxiedConnectionFactory myFactory;
    protected final AtomicReference<Connection> myLastUsedConnection;
    protected final PropertyChangeListener myListener;
    protected volatile K myMainKey;
    protected final AtomicBoolean myOpen;
    protected final AtomicBoolean myShutdown;
    final ConcurrentMap<K, Connection> myConnections;

    public AbstractProxyMultipleConnection(Connection connection, K k, Cluster cluster, ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myMainKey = k;
        this.myCluster = cluster;
        this.myFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myOpen = new AtomicBoolean(true);
        this.myShutdown = new AtomicBoolean(false);
        this.myEventSupport = new PropertyChangeSupport(this);
        this.myConnections = new ConcurrentHashMap<K, Connection>();
        this.myLastUsedConnection = new AtomicReference<Connection>(connection);
        this.myListener = new ClusterAndConnectionListener();
        this.myCluster.addListener(this.myListener);
        if (connection != null) {
            this.cacheConnection(k, connection);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myEventSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void close() {
        this.myOpen.set(false);
        this.myCluster.removeListener(this.myListener);
        for (Connection connection : this.myConnections.values()) {
            try {
                connection.removePropertyChangeListener(this.myListener);
                connection.close();
            }
            catch (IOException iOException) {
                LOG.warn(iOException, "Could not close the connection: {}", connection);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        for (Connection connection : this.myConnections.values()) {
            try {
                connection.flush();
            }
            catch (IOException iOException) {
                LOG.warn(iOException, "Could not flush the connection: {}", connection);
            }
        }
    }

    @Override
    public int getPendingCount() {
        return this.myLastUsedConnection.get().getPendingCount();
    }

    @Override
    public boolean isAvailable() {
        return this.isOpen() && !this.isShuttingDown();
    }

    @Override
    public boolean isIdle() {
        return this.myLastUsedConnection.get().isIdle();
    }

    @Override
    public boolean isOpen() {
        return this.myOpen.get();
    }

    @Override
    public boolean isShuttingDown() {
        return this.myShutdown.get();
    }

    @Override
    public void raiseErrors(MongoDbException mongoDbException) {
        for (Connection connection : this.myConnections.values()) {
            connection.raiseErrors(mongoDbException);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myEventSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void send(Message message, Message message2, ReplyCallback replyCallback) throws MongoDbException {
        if (!this.isAvailable()) {
            throw new ConnectionLostException("Connection shutting down.");
        }
        List<K> list = this.findPotentialKeys(message, message2);
        if (!this.trySend(list, message, message2, replyCallback)) {
            throw new MongoDbException("Could not send the messages to any of the potential servers.");
        }
    }

    @Override
    public void send(Message message, ReplyCallback replyCallback) throws MongoDbException {
        this.send(message, null, replyCallback);
    }

    @Override
    public void shutdown(boolean bl) {
        this.myShutdown.set(true);
        for (Connection connection : this.myConnections.values()) {
            connection.shutdown(bl);
        }
    }

    public String toString() {
        return this.getConnectionType() + "(" + this.myLastUsedConnection.get() + ")";
    }

    @Override
    public void waitForClosed(int n, TimeUnit timeUnit) {
        long l = timeUnit.toMillis(n);
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        for (Connection connection : this.myConnections.values()) {
            if (l2 >= l3) continue;
            connection.waitForClosed((int)(l3 - l2), TimeUnit.MILLISECONDS);
            l2 = System.currentTimeMillis();
        }
    }

    protected Connection cacheConnection(K k, Connection connection) {
        Connection connection2 = this.myConnections.putIfAbsent(k, connection);
        if (connection2 != null) {
            connection.shutdown(true);
            return connection2;
        }
        connection.addPropertyChangeListener(this.myListener);
        return connection;
    }

    protected abstract Connection connect(K var1);

    protected Connection connection(K k) {
        return (Connection)this.myConnections.get(k);
    }

    protected MongoDbException createReconnectFailure(Message message, Message message2) {
        StringBuilder stringBuilder = new StringBuilder("Could not find any servers for the following set of read preferences: ");
        HashSet<ReadPreference> hashSet = new HashSet<ReadPreference>();
        for (Message message3 : Arrays.asList(message, message2)) {
            ReadPreference readPreference;
            if (message3 == null || !hashSet.add(readPreference = message3.getReadPreference())) continue;
            if (hashSet.size() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(readPreference);
        }
        stringBuilder.append('.');
        return new MongoDbException(stringBuilder.toString());
    }

    protected void doSend(Connection connection, Message message, Message message2, ReplyCallback replyCallback) {
        this.myLastUsedConnection.lazySet(connection);
        if (message2 == null) {
            connection.send(message, replyCallback);
        } else {
            connection.send(message, message2, replyCallback);
        }
    }

    protected abstract List<K> findPotentialKeys(Message var1, Message var2) throws MongoDbException;

    protected abstract String getConnectionType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handleConnectionClosed(Connection connection) {
        if (!this.myOpen.get()) {
            return;
        }
        K k = this.findKeyForConnection(connection);
        try {
            K k2 = this.myMainKey;
            if (this.myConnections.size() == 1 && (!k.equals(k2) || connection.isShuttingDown())) {
                this.removeCachedConnection(k, connection);
                this.shutdown(true);
                this.myEventSupport.firePropertyChange("open", true, this.isOpen());
            } else if (k.equals(k2) && this.isOpen()) {
                this.myMainKey = null;
                LOG.info("Primary MongoDB Connection closed: {}({}). Will try to reconnect.", this.getConnectionType(), connection);
                ConnectionInfo<K> connectionInfo = this.reconnectMain();
                if (connectionInfo != null) {
                    this.removeCachedConnection(k, connection);
                    this.updateMain(connectionInfo);
                } else if (this.myConnections.size() == 1) {
                    this.removeCachedConnection(k, connection);
                    this.shutdown(false);
                    this.myEventSupport.firePropertyChange("open", true, this.isOpen());
                }
            } else {
                LOG.debug("MongoDB Connection closed: {}({}).", this.getConnectionType(), connection);
            }
        }
        finally {
            this.removeCachedConnection(k, connection);
            connection.raiseErrors(new ConnectionLostException("Connection closed."));
        }
    }

    protected abstract ConnectionInfo<K> reconnectMain();

    protected void removeCachedConnection(Object object, Connection connection) {
        Connection connection2 = connection;
        if (connection == null) {
            connection2 = (Connection)this.myConnections.remove(object);
        } else if (!this.myConnections.remove(object, connection)) {
            connection2 = null;
        }
        if (connection2 != null) {
            connection2.removePropertyChangeListener(this.myListener);
            connection2.shutdown(true);
        }
    }

    protected boolean trySend(List<K> list, Message message, Message message2, ReplyCallback replyCallback) {
        for (K k : list) {
            Connection connection = (Connection)this.myConnections.get(k);
            if (connection == null) {
                connection = this.connect(k);
            } else if (!connection.isAvailable()) {
                this.removeCachedConnection(k, connection);
                ReconnectStrategy reconnectStrategy = this.myFactory.getReconnectStrategy();
                connection = reconnectStrategy.reconnect(connection);
                if (connection != null) {
                    connection = this.cacheConnection(k, connection);
                }
            }
            if (connection == null) continue;
            this.doSend(connection, message, message2, replyCallback);
            return true;
        }
        return false;
    }

    protected void updateMain(ConnectionInfo<K> connectionInfo) {
        this.myMainKey = connectionInfo.getConnectionKey();
        this.cacheConnection(connectionInfo.getConnectionKey(), connectionInfo.getConnection());
    }

    private K findKeyForConnection(Connection connection) {
        for (Map.Entry entry : this.myConnections.entrySet()) {
            if (entry.getValue() != connection) continue;
            return entry.getKey();
        }
        return null;
    }

    protected final class ClusterAndConnectionListener
    implements PropertyChangeListener {
        protected ClusterAndConnectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("server".equals(string) && propertyChangeEvent.getNewValue() == null) {
                AbstractProxyMultipleConnection.this.removeCachedConnection(propertyChangeEvent.getOldValue(), null);
            } else if ("open".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                AbstractProxyMultipleConnection.this.handleConnectionClosed((Connection)propertyChangeEvent.getSource());
            }
        }
    }
}

