/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.rs;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.proxy.AbstractProxyMultipleConnection;
import com.allanbank.mongodb.client.connection.proxy.ConnectionInfo;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.connection.rs.ReplicaSetReconnectStrategy;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.util.List;

public class ReplicaSetConnection
extends AbstractProxyMultipleConnection<Server> {
    private static final Log LOG = LogFactory.getLog(ReplicaSetConnection.class);
    private volatile ReplicaSetReconnectStrategy myReconnectStrategy;

    public ReplicaSetConnection(Connection connection, Server server, Cluster cluster, ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration, ReplicaSetReconnectStrategy replicaSetReconnectStrategy) {
        super(connection, server, cluster, proxiedConnectionFactory, mongoClientConfiguration);
        this.myReconnectStrategy = replicaSetReconnectStrategy;
    }

    @Override
    public String getServerName() {
        if (this.myMainKey != null) {
            return ((Server)this.myMainKey).getCanonicalName();
        }
        return "UNKNOWN";
    }

    @Override
    protected Connection connect(Server server) {
        Connection connection = null;
        try {
            connection = this.myFactory.connect(server, this.myConfig);
            connection = this.cacheConnection(server, connection);
        }
        catch (IOException iOException) {
            LOG.info("Could not connect to the server '" + server.getCanonicalName() + "': " + iOException.getMessage());
        }
        return connection;
    }

    @Override
    protected List<Server> findPotentialKeys(Message message, Message message2) throws MongoDbException {
        List<Server> list = this.myCluster.findServers(message, message2);
        if (list.isEmpty()) {
            ConnectionInfo<Server> connectionInfo;
            if (this.myMainKey == null && (connectionInfo = this.reconnectMain()) != null) {
                this.updateMain(connectionInfo);
                list = this.myCluster.findServers(message, message2);
            }
            if (list.isEmpty()) {
                throw this.createReconnectFailure(message, message2);
            }
        }
        return list;
    }

    @Override
    protected String getConnectionType() {
        return "ReplicaSet";
    }

    @Override
    protected ConnectionInfo<Server> reconnectMain() {
        return this.myReconnectStrategy.reconnectPrimary();
    }
}

