/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.sharded;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.proxy.AbstractProxyMultipleConnection;
import com.allanbank.mongodb.client.connection.proxy.ConnectionInfo;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerSelector;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ShardedConnection
extends AbstractProxyMultipleConnection<Server> {
    private static final Log LOG = LogFactory.getLog(ShardedConnection.class);
    private final ServerSelector mySelector;

    public ShardedConnection(Connection connection, Server server, Cluster cluster, ServerSelector serverSelector, ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        super(connection, server, cluster, proxiedConnectionFactory, mongoClientConfiguration);
        this.mySelector = serverSelector;
    }

    @Override
    public String getServerName() {
        if (this.myMainKey != null) {
            return ((Server)this.myMainKey).getCanonicalName();
        }
        return "UNKNOWN";
    }

    @Override
    protected Connection connect(Server server) {
        Connection connection = null;
        try {
            connection = this.myFactory.connect(server, this.myConfig);
            connection = this.cacheConnection(server, connection);
        }
        catch (IOException iOException) {
            LOG.info(iOException, "Could not connect to the server '{}': {}", server.getCanonicalName(), iOException.getMessage());
        }
        return connection;
    }

    @Override
    protected Connection connection(Server server) {
        LOG.debug("Lookup connection for server: {}", server.getCanonicalName());
        return super.connection(server);
    }

    @Override
    protected List<Server> findPotentialKeys(Message message, Message message2) throws MongoDbException {
        List<Server> list = this.resolveServerReadPreference(message, message2);
        if (list.isEmpty()) {
            ConnectionInfo<Server> connectionInfo;
            if (this.myMainKey == null && (connectionInfo = this.reconnectMain()) != null) {
                this.updateMain(connectionInfo);
                list = this.resolveServerReadPreference(message, message2);
            }
            if (list.isEmpty()) {
                throw this.createReconnectFailure(message, message2);
            }
        }
        return list;
    }

    @Override
    protected String getConnectionType() {
        return "Sharded";
    }

    @Override
    protected ConnectionInfo<Server> reconnectMain() {
        for (Server server : this.mySelector.pickServers()) {
            try {
                Connection connection = this.myFactory.connect(server, this.myConfig);
                return new ConnectionInfo<Server>(connection, server);
            }
            catch (IOException iOException) {
                LOG.debug(iOException, "Could not connect to '{}': {}", server.getCanonicalName(), iOException.getMessage());
            }
        }
        return null;
    }

    private List<Server> resolveServerReadPreference(Message message, Message message2) {
        List<Server> list = Collections.emptyList();
        Server server = (Server)this.myMainKey;
        if (server != null) {
            list = Collections.singletonList(server);
        }
        if (message != null) {
            ReadPreference readPreference = message.getReadPreference();
            if (readPreference.getServer() != null) {
                list = Collections.singletonList(this.myCluster.get(readPreference.getServer()));
            } else if (message2 != null && (readPreference = message2.getReadPreference()).getServer() != null) {
                list = Collections.singletonList(this.myCluster.get(readPreference.getServer()));
            }
        }
        return list;
    }
}

