/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.sharded;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.callback.FutureReplyCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ConnectionFactory;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.connection.sharded.ShardedConnection;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.client.message.GetMore;
import com.allanbank.mongodb.client.message.Query;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.ClusterPinger;
import com.allanbank.mongodb.client.state.LatencyServerSelector;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerSelector;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public class ShardedConnectionFactory
implements ConnectionFactory {
    protected static final Log LOG = LogFactory.getLog(ShardedConnectionFactory.class);
    protected final Cluster myCluster;
    protected final MongoClientConfiguration myConfig;
    protected final ProxiedConnectionFactory myConnectionFactory;
    protected final ClusterPinger myPinger;
    protected final ServerSelector mySelector;

    public ShardedConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myCluster = this.createCluster(mongoClientConfiguration);
        this.mySelector = this.createSelector();
        this.myPinger = this.createClusterPinger(proxiedConnectionFactory, mongoClientConfiguration);
        for (InetSocketAddress inetSocketAddress : mongoClientConfiguration.getServerAddresses()) {
            this.myCluster.add(inetSocketAddress);
        }
        this.bootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        BootstrapState bootstrapState = this.createBootstrapState();
        if (!bootstrapState.done()) {
            for (Server server : this.myCluster.getServers()) {
                Connection connection = null;
                try {
                    connection = this.myConnectionFactory.connect(server, this.myConfig);
                    this.update(bootstrapState, connection);
                    if (!bootstrapState.done()) continue;
                    break;
                }
                catch (IOException iOException) {
                    LOG.warn(iOException, "I/O error during sharded bootstrap to {}.", server);
                }
                catch (MongoDbException mongoDbException) {
                    LOG.warn(mongoDbException, "MongoDB error during sharded bootstrap to {}.", server);
                }
                catch (InterruptedException interruptedException) {
                    LOG.warn(interruptedException, "Interrupted during sharded bootstrap to {}.", server);
                }
                catch (ExecutionException executionException) {
                    LOG.warn(executionException, "Error during sharded bootstrap to {}.", server);
                }
                finally {
                    IOUtils.close(connection, Level.WARNING, "I/O error shutting down sharded bootstrap connection to " + server + ".");
                }
            }
        }
        this.myPinger.initialSweep(this.myCluster);
        this.myPinger.start();
    }

    @Override
    public void close() {
        IOUtils.close(this.myPinger);
        IOUtils.close(this.myConnectionFactory);
    }

    @Override
    public Connection connect() throws IOException {
        IOException iOException = null;
        for (Server server : this.mySelector.pickServers()) {
            try {
                Connection connection = this.myConnectionFactory.connect(server, this.myConfig);
                return this.wrap(connection, server);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("Could not determine a shard server to connect to.");
    }

    @Override
    public ClusterStats getClusterStats() {
        return this.myCluster;
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.SHARDED;
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        ReconnectStrategy reconnectStrategy = this.myConnectionFactory.getReconnectStrategy();
        reconnectStrategy.setState(this.myCluster);
        reconnectStrategy.setSelector(this.mySelector);
        reconnectStrategy.setConnectionFactory(this.myConnectionFactory);
        return reconnectStrategy;
    }

    protected BootstrapState createBootstrapState() {
        return new BootstrapState(!this.myConfig.isAutoDiscoverServers());
    }

    protected Cluster createCluster(MongoClientConfiguration mongoClientConfiguration) {
        return new Cluster(mongoClientConfiguration, ClusterType.SHARDED);
    }

    protected ClusterPinger createClusterPinger(ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        return new ClusterPinger(this.myCluster, proxiedConnectionFactory, mongoClientConfiguration);
    }

    protected ServerSelector createSelector() {
        return new LatencyServerSelector(this.myCluster, true);
    }

    protected boolean findMongosServers(Connection connection) throws InterruptedException, ExecutionException {
        boolean bl = false;
        AbstractMessage abstractMessage = new Query("config", "mongos", Find.ALL, null, 0, 0, 0, false, ReadPreference.PRIMARY, false, false, false, false);
        while (abstractMessage != null) {
            FutureReplyCallback futureReplyCallback = new FutureReplyCallback();
            connection.send(abstractMessage, futureReplyCallback);
            abstractMessage = null;
            Reply reply = (Reply)futureReplyCallback.get();
            List<Document> list = reply.getResults();
            for (Document document : list) {
                Element element = document.get("_id");
                if (!(element instanceof StringElement)) continue;
                StringElement stringElement = (StringElement)element;
                this.myCluster.add(stringElement.getValue());
                bl = true;
                LOG.debug("Adding shard mongos: {}", stringElement.getValue());
            }
            if (reply.getCursorId() == 0L) continue;
            abstractMessage = new GetMore("config", "mongos", reply.getCursorId(), 0, ReadPreference.PRIMARY);
        }
        return bl;
    }

    protected Cluster getCluster() {
        return this.myCluster;
    }

    protected void update(BootstrapState bootstrapState, Connection connection) throws InterruptedException, ExecutionException {
        if (bootstrapState.isMongosFound() || this.findMongosServers(connection)) {
            bootstrapState.setMongosFound(true);
        }
    }

    protected Connection wrap(Connection connection, Server server) {
        return new ShardedConnection(connection, server, this.myCluster, this.mySelector, this.myConnectionFactory, this.myConfig);
    }

    protected static class BootstrapState {
        private boolean myMongosFound;

        protected BootstrapState(boolean bl) {
            this.myMongosFound = bl;
        }

        public boolean done() {
            return this.myMongosFound;
        }

        public boolean isMongosFound() {
            return this.myMongosFound;
        }

        public void setMongosFound(boolean bl) {
            this.myMongosFound = bl;
        }
    }
}

