/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.socket;

import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.client.message.PendingMessageQueue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class Sequence {
    private static final int RELEASE_OFFSET = 22;
    private static final int RESERVE_OFFSET = 7;
    private static final long YIELD_TIME_NS = PendingMessageQueue.YIELD_TIME_NS;
    private final Condition myCondition;
    private final Lock myLock;
    private final LockType myLockType;
    private final AtomicLongArray myPaddedValue = new AtomicLongArray(30);
    private final SortedMap<Long, Condition> myWaiters;
    private final AtomicInteger myWaiting;

    public Sequence(long l) {
        this(l, LockType.MUTEX);
    }

    public Sequence(long l, LockType lockType) {
        this.myPaddedValue.set(7, l);
        this.myPaddedValue.set(22, l);
        this.myLockType = lockType;
        this.myLock = new ReentrantLock(true);
        this.myCondition = this.myLock.newCondition();
        this.myWaiting = new AtomicInteger(0);
        this.myWaiters = new TreeMap<Long, Condition>();
    }

    public int getWaitersCount() {
        long l = this.myPaddedValue.get(7);
        long l2 = this.myPaddedValue.get(22);
        return (int)(l2 - l);
    }

    public boolean isIdle() {
        long l;
        long l2 = this.myPaddedValue.get(7);
        return l2 == (l = this.myPaddedValue.get(22));
    }

    public boolean noWaiter(long l) {
        long l2 = this.myPaddedValue.get(7);
        return l2 == l;
    }

    public void release(long l, long l2) {
        while (!this.compareAndSetRelease(l, l2)) {
            Thread.yield();
        }
        this.notifyWaiters();
    }

    public long reserve(long l) {
        long l2;
        long l3;
        while (!this.compareAndSetReserve(l3 = this.myPaddedValue.get(7), l2 = l3 + l)) {
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(long l) {
        long l2 = this.myPaddedValue.get(22);
        while (l2 != l) {
            if (this.myLockType == LockType.LOW_LATENCY_SPIN) {
                long l3 = System.nanoTime();
                long l4 = l3 + YIELD_TIME_NS;
                l2 = this.myPaddedValue.get(22);
                while (l3 < l4 && l2 != l) {
                    Thread.yield();
                    l3 = System.nanoTime();
                    l2 = this.myPaddedValue.get(22);
                }
            }
            if (l2 == l) continue;
            Long l5 = l;
            Condition condition = this.myCondition;
            try {
                int n = this.myWaiting.incrementAndGet();
                this.myLock.lock();
                try {
                    if (n > 1) {
                        condition = this.myLock.newCondition();
                        this.myWaiters.put(l5, condition);
                    }
                    l2 = this.myPaddedValue.get(22);
                    while (l2 != l) {
                        condition.awaitUninterruptibly();
                        l2 = this.myPaddedValue.get(22);
                    }
                }
                finally {
                    if (condition == this.myCondition) continue;
                    this.myWaiters.remove(l5);
                }
            }
            finally {
                this.myLock.unlock();
                this.myWaiting.decrementAndGet();
            }
        }
    }

    private boolean compareAndSetRelease(long l, long l2) {
        return this.myPaddedValue.compareAndSet(22, l, l2);
    }

    private boolean compareAndSetReserve(long l, long l2) {
        return this.myPaddedValue.compareAndSet(7, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        if (this.myWaiting.get() > 0) {
            try {
                this.myLock.lock();
                this.myCondition.signalAll();
                if (!this.myWaiters.isEmpty()) {
                    ((Condition)this.myWaiters.get(this.myWaiters.firstKey())).signalAll();
                }
            }
            finally {
                this.myLock.unlock();
            }
        }
    }
}

