/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.socket;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.RandomAccessOutputStream;
import com.allanbank.mongodb.bson.io.StringDecoderCache;
import com.allanbank.mongodb.bson.io.StringEncoderCache;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.AddressAware;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.connection.socket.AbstractSocketConnection;
import com.allanbank.mongodb.client.connection.socket.ReceiveRunnable;
import com.allanbank.mongodb.client.connection.socket.Sequence;
import com.allanbank.mongodb.client.message.BuildInfo;
import com.allanbank.mongodb.client.message.PendingMessage;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerUpdateCallback;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.SocketException;

public class SocketConnection
extends AbstractSocketConnection {
    private final ThreadLocal<Reference<BufferingBsonOutputStream>> myBuffers;
    private final Thread myReceiver;
    private final Sequence mySendSequence;

    public SocketConnection(Server server, MongoClientConfiguration mongoClientConfiguration) throws SocketException, IOException {
        this(server, mongoClientConfiguration, new StringEncoderCache(), new StringDecoderCache(), new ThreadLocal<Reference<BufferingBsonOutputStream>>());
    }

    public SocketConnection(Server server, MongoClientConfiguration mongoClientConfiguration, StringEncoderCache stringEncoderCache, StringDecoderCache stringDecoderCache, ThreadLocal<Reference<BufferingBsonOutputStream>> threadLocal) throws SocketException, IOException {
        super(server, mongoClientConfiguration, stringEncoderCache, stringDecoderCache);
        this.myBuffers = threadLocal;
        this.mySendSequence = new Sequence(1L, mongoClientConfiguration.getLockType());
        this.myReceiver = mongoClientConfiguration.getThreadFactory().newThread(new ReceiveRunnable(this));
        this.myReceiver.setDaemon(true);
        this.myReceiver.setName("MongoDB " + this.mySocket.getLocalPort() + "<--" + this.myServer.getCanonicalName());
    }

    @Override
    public void close() throws IOException {
        if (this.myOpen.compareAndSet(true, false)) {
            this.myReceiver.interrupt();
            this.myOutput.close();
            this.myInput.close();
            this.mySocket.close();
            try {
                if (Thread.currentThread() != this.myReceiver) {
                    this.myReceiver.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.myEventSupport.firePropertyChange("open", true, false);
        }
    }

    @Override
    public int getPendingCount() {
        return super.getPendingCount() + this.mySendSequence.getWaitersCount();
    }

    @Override
    public boolean isIdle() {
        return super.isIdle() && this.mySendSequence.isIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(Message message, Message message2, ReplyCallback replyCallback) throws MongoDbException {
        this.validate(message, message2);
        if (replyCallback instanceof AddressAware) {
            ((AddressAware)((Object)replyCallback)).setAddress(this.myServer.getCanonicalName());
        }
        int n = message2 == null ? 1 : 2;
        long l = this.mySendSequence.reserve(n);
        long l2 = l + (long)n;
        boolean bl = false;
        PendingMessage pendingMessage = new PendingMessage();
        try {
            BufferingBsonOutputStream bufferingBsonOutputStream;
            Reference<BufferingBsonOutputStream> reference = this.myBuffers.get();
            BufferingBsonOutputStream bufferingBsonOutputStream2 = bufferingBsonOutputStream = reference != null ? reference.get() : null;
            if (bufferingBsonOutputStream == null) {
                bufferingBsonOutputStream = new BufferingBsonOutputStream(new RandomAccessOutputStream(this.myEncoderCache));
                this.myBuffers.set(new SoftReference<BufferingBsonOutputStream>(bufferingBsonOutputStream));
            }
            message.write((int)(l & 0xFFFFFFL), bufferingBsonOutputStream);
            if (message2 != null) {
                message2.write((int)(l + 1L & 0xFFFFFFL), bufferingBsonOutputStream);
            }
            this.mySendSequence.waitFor(l);
            if (n == 1) {
                pendingMessage.set((int)(l & 0xFFFFFFL), message, replyCallback);
                this.send(pendingMessage, bufferingBsonOutputStream.getOutput());
            } else {
                pendingMessage.set((int)(l + 1L & 0xFFFFFFL), message2, replyCallback);
                this.send(pendingMessage, bufferingBsonOutputStream.getOutput());
            }
            if (!this.mySendSequence.noWaiter(l2)) return;
            if (this.myReceiver != Thread.currentThread()) {
                this.flush();
                return;
            }
            this.markReaderNeedsToFlush();
            return;
        }
        catch (InterruptedException interruptedException) {
            this.raiseError(interruptedException, pendingMessage.getReplyCallback());
            return;
        }
        catch (IOException iOException) {
            this.myLog.warn(iOException, "I/O Error sending a message.", new Object[0]);
            this.raiseError(iOException, pendingMessage.getReplyCallback());
            bl = true;
            return;
        }
        catch (RuntimeException runtimeException) {
            this.myLog.warn(runtimeException, "Runtime error sending a message.", new Object[0]);
            this.raiseError(runtimeException, pendingMessage.getReplyCallback());
            bl = true;
            return;
        }
        catch (Error error) {
            this.myLog.error(error, "Error sending a message.", new Object[0]);
            this.raiseError(error, pendingMessage.getReplyCallback());
            bl = true;
            return;
        }
        finally {
            pendingMessage.clear();
            this.mySendSequence.release(l, l2);
            if (bl) {
                try {
                    if (this.myOpen.get()) {
                        this.flush();
                    }
                }
                catch (IOException iOException) {
                    this.myLog.warn(iOException, "I/O Error on final flush of messages.", new Object[0]);
                }
                finally {
                    IOUtils.close(this);
                }
            }
        }
    }

    @Override
    public void send(Message message, ReplyCallback replyCallback) throws MongoDbException {
        this.send(message, null, replyCallback);
    }

    @Override
    public void start() {
        this.myReceiver.start();
        if (this.myServer.needBuildInfo()) {
            this.send(new BuildInfo(), new ServerUpdateCallback(this.myServer));
        }
    }
}

