/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.socket;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.RandomAccessOutputStream;
import com.allanbank.mongodb.bson.io.StringDecoderCache;
import com.allanbank.mongodb.bson.io.StringEncoderCache;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.AddressAware;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.connection.socket.AbstractSocketConnection;
import com.allanbank.mongodb.client.connection.socket.ReceiveRunnable;
import com.allanbank.mongodb.client.message.BuildInfo;
import com.allanbank.mongodb.client.message.PendingMessage;
import com.allanbank.mongodb.client.message.PendingMessageQueue;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerUpdateCallback;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.net.SocketException;

public class TwoThreadSocketConnection
extends AbstractSocketConnection {
    protected final BufferingBsonOutputStream myBsonOut;
    protected final PendingMessageQueue myToSendQueue;
    private final Thread myReceiver;
    private final Thread mySender;

    public TwoThreadSocketConnection(Server server, MongoClientConfiguration mongoClientConfiguration) throws SocketException, IOException {
        this(server, mongoClientConfiguration, new StringEncoderCache(), new StringDecoderCache());
    }

    public TwoThreadSocketConnection(Server server, MongoClientConfiguration mongoClientConfiguration, StringEncoderCache stringEncoderCache, StringDecoderCache stringDecoderCache) throws SocketException, IOException {
        super(server, mongoClientConfiguration, stringEncoderCache, stringDecoderCache);
        this.myBsonOut = new BufferingBsonOutputStream(new RandomAccessOutputStream(stringEncoderCache));
        this.myToSendQueue = new PendingMessageQueue(mongoClientConfiguration.getMaxPendingOperationsPerConnection(), mongoClientConfiguration.getLockType());
        this.myReceiver = mongoClientConfiguration.getThreadFactory().newThread(new ReceiveRunnable(this));
        this.myReceiver.setDaemon(true);
        this.myReceiver.setName("MongoDB " + this.mySocket.getLocalPort() + "<--" + this.myServer.getCanonicalName());
        this.mySender = mongoClientConfiguration.getThreadFactory().newThread(new SendRunnable());
        this.mySender.setDaemon(true);
        this.mySender.setName("MongoDB " + this.mySocket.getLocalPort() + "-->" + this.myServer.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean bl = this.myOpen.get();
        this.myOpen.set(false);
        this.mySender.interrupt();
        this.myReceiver.interrupt();
        try {
            if (Thread.currentThread() != this.mySender) {
                this.mySender.join();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.myOutput.close();
            this.myInput.close();
            this.mySocket.close();
        }
        try {
            if (Thread.currentThread() != this.myReceiver) {
                this.myReceiver.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myEventSupport.firePropertyChange("open", bl, false);
    }

    @Override
    public int getPendingCount() {
        return super.getPendingCount() + this.myToSendQueue.size();
    }

    @Override
    public boolean isIdle() {
        return super.isIdle() && this.myToSendQueue.isEmpty();
    }

    @Override
    public void raiseErrors(MongoDbException mongoDbException) {
        PendingMessage pendingMessage = new PendingMessage();
        while (this.myToSendQueue.poll(pendingMessage)) {
            this.raiseError(mongoDbException, pendingMessage.getReplyCallback());
        }
        super.raiseErrors(mongoDbException);
    }

    @Override
    public void send(Message message, Message message2, ReplyCallback replyCallback) throws MongoDbException {
        this.validate(message, message2);
        if (replyCallback instanceof AddressAware) {
            ((AddressAware)((Object)replyCallback)).setAddress(this.myServer.getCanonicalName());
        }
        try {
            this.myToSendQueue.put(message, null, message2, replyCallback);
        }
        catch (InterruptedException interruptedException) {
            throw new MongoDbException(interruptedException);
        }
    }

    @Override
    public void send(Message message, ReplyCallback replyCallback) throws MongoDbException {
        this.validate(message, null);
        if (replyCallback instanceof AddressAware) {
            ((AddressAware)((Object)replyCallback)).setAddress(this.myServer.getCanonicalName());
        }
        try {
            this.myToSendQueue.put(message, replyCallback);
        }
        catch (InterruptedException interruptedException) {
            throw new MongoDbException(interruptedException);
        }
    }

    @Override
    public void start() {
        this.myReceiver.start();
        this.mySender.start();
        if (this.myServer.needBuildInfo()) {
            this.send(new BuildInfo(), new ServerUpdateCallback(this.myServer));
        }
    }

    protected class SendRunnable
    implements Runnable {
        private boolean myNeedToFlush = false;
        private final PendingMessage myPendingMessage = new PendingMessage();

        protected SendRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            try {
                while (TwoThreadSocketConnection.this.myOpen.get() && !bl) {
                    try {
                        this.sendOne();
                    }
                    catch (InterruptedException interruptedException) {
                        TwoThreadSocketConnection.this.raiseError(interruptedException, this.myPendingMessage.getReplyCallback());
                    }
                    catch (IOException iOException) {
                        TwoThreadSocketConnection.this.myLog.warn(iOException, "I/O Error sending a message.", new Object[0]);
                        TwoThreadSocketConnection.this.raiseError(iOException, this.myPendingMessage.getReplyCallback());
                        bl = true;
                    }
                    catch (RuntimeException runtimeException) {
                        TwoThreadSocketConnection.this.myLog.warn(runtimeException, "Runtime error sending a message.", new Object[0]);
                        TwoThreadSocketConnection.this.raiseError(runtimeException, this.myPendingMessage.getReplyCallback());
                        bl = true;
                    }
                    catch (Error error) {
                        TwoThreadSocketConnection.this.myLog.error(error, "Error sending a message.", new Object[0]);
                        TwoThreadSocketConnection.this.raiseError(error, this.myPendingMessage.getReplyCallback());
                        bl = true;
                    }
                    finally {
                        this.myPendingMessage.clear();
                    }
                }
                return;
            }
            finally {
                try {
                    if (TwoThreadSocketConnection.this.myOpen.get()) {
                        this.doFlush();
                    }
                }
                catch (IOException iOException) {
                    TwoThreadSocketConnection.this.myLog.warn(iOException, "I/O Error on final flush of messages.", new Object[0]);
                }
                finally {
                    IOUtils.close(TwoThreadSocketConnection.this);
                }
            }
        }

        protected final void doFlush() throws IOException {
            if (this.myNeedToFlush) {
                TwoThreadSocketConnection.this.flush();
                this.myNeedToFlush = false;
            }
        }

        protected final void sendOne() throws InterruptedException, IOException {
            boolean bl = false;
            if (this.myNeedToFlush) {
                bl = TwoThreadSocketConnection.this.myToSendQueue.poll(this.myPendingMessage);
            } else {
                TwoThreadSocketConnection.this.myToSendQueue.take(this.myPendingMessage);
                bl = true;
            }
            if (bl) {
                this.myNeedToFlush = true;
                this.myPendingMessage.getMessage().write(this.myPendingMessage.getMessageId(), TwoThreadSocketConnection.this.myBsonOut);
                TwoThreadSocketConnection.this.send(this.myPendingMessage, TwoThreadSocketConnection.this.myBsonOut.getOutput());
                this.myPendingMessage.clear();
            } else {
                this.doFlush();
            }
        }
    }
}

