/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.message.Command;

public class CreateIndexCommand
extends Command {
    public static final Version REQUIRED_VERSION = Version.VERSION_2_6;
    public static final VersionRange REQUIRED_VERSION_RANGE = VersionRange.minimum(REQUIRED_VERSION);

    public static String buildIndexName(Element ... elementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : elementArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('_');
            }
            stringBuilder.append(element.getName().replace(' ', '_'));
            stringBuilder.append("_");
            if (element instanceof NumericElement) {
                stringBuilder.append(((NumericElement)element).getIntValue());
                continue;
            }
            stringBuilder.append(element.getValueAsString());
        }
        return stringBuilder.toString();
    }

    private static Document buildCommand(String string, Element[] elementArray, String string2, DocumentAssignable documentAssignable) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("createIndexes", string);
        DocumentBuilder documentBuilder2 = documentBuilder.pushArray("indexes").push();
        DocumentBuilder documentBuilder3 = documentBuilder2.push("key");
        for (Element element : elementArray) {
            documentBuilder3.add(element);
        }
        documentBuilder2.add("name", string2 == null ? CreateIndexCommand.buildIndexName(elementArray) : string2);
        if (documentAssignable != null) {
            for (Element element : documentAssignable.asDocument()) {
                documentBuilder2.add(element);
            }
        }
        return documentBuilder.build();
    }

    public CreateIndexCommand(String string, String string2, Element[] elementArray, String string3, DocumentAssignable documentAssignable) {
        super(string, string2, CreateIndexCommand.buildCommand(string2, elementArray, string3, documentAssignable), ReadPreference.PRIMARY, REQUIRED_VERSION_RANGE);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            bl = super.equals(object);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        return n;
    }
}

