/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;

public class Delete
extends AbstractMessage {
    public static final int SINGLE_DELETE_BIT = 1;
    private final Document myQuery;
    private final boolean mySingleDelete;

    public Delete(BsonInputStream bsonInputStream) throws IOException {
        bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        int n = bsonInputStream.readInt();
        this.myQuery = bsonInputStream.readDocument();
        this.mySingleDelete = (n & 1) == 1;
    }

    public Delete(String string, String string2, Document document, boolean bl) {
        super(string, string2, ReadPreference.PRIMARY);
        this.myQuery = document;
        this.mySingleDelete = bl;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Delete delete = (Delete)object;
            bl = super.equals(object) && this.mySingleDelete == delete.mySingleDelete && this.myQuery.equals(delete.myQuery);
        }
        return bl;
    }

    @Override
    public String getOperationName() {
        return Operation.DELETE.name();
    }

    public Document getQuery() {
        return this.myQuery;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.mySingleDelete ? 1 : 3);
        n = 31 * n + this.myQuery.hashCode();
        return n;
    }

    public boolean isSingleDelete() {
        return this.mySingleDelete;
    }

    @Override
    public int size() {
        int n = 26;
        n += StringEncoder.utf8Size(this.myDatabaseName);
        n += StringEncoder.utf8Size(this.myCollectionName);
        n = (int)((long)n + this.myQuery.size());
        return n;
    }

    @Override
    public void validateSize(int n) throws DocumentToLargeException {
        long l = this.myQuery.size();
        if ((long)n < l) {
            throw new DocumentToLargeException((int)l, n, this.myQuery);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        n3 += 4;
        n3 = (int)((long)n3 + this.myQuery.size());
        this.writeHeader(bsonOutputStream, n, 0, Operation.DELETE, n3);
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeDocument(this.myQuery);
    }

    @Override
    public void write(int n, BufferingBsonOutputStream bufferingBsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        long l = this.writeHeader(bufferingBsonOutputStream, n, 0, Operation.DELETE);
        bufferingBsonOutputStream.writeInt(0);
        bufferingBsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bufferingBsonOutputStream.writeInt(n2);
        bufferingBsonOutputStream.writeDocument(this.myQuery);
        this.finishHeader(bufferingBsonOutputStream, l);
        bufferingBsonOutputStream.flushBuffer();
    }

    private int computeFlags() {
        int n = 0;
        if (this.mySingleDelete) {
            ++n;
        }
        return n;
    }
}

