/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.client.message.Header;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Insert
extends AbstractMessage {
    public static final int CONTINUE_ON_ERROR_BIT = 1;
    private final boolean myContinueOnError;
    private final List<Document> myDocuments;
    private int myDocumentsSize;

    public Insert(Header header, BsonInputStream bsonInputStream) throws IOException {
        long l = bsonInputStream.getBytesRead();
        long l2 = l + (long)header.getLength() - 16L;
        int n = bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        this.myDocuments = new ArrayList<Document>();
        while (bsonInputStream.getBytesRead() < l2) {
            this.myDocuments.add(bsonInputStream.readDocument());
        }
        this.myContinueOnError = (n & 1) == 1;
        this.myDocumentsSize = -1;
    }

    public Insert(String string, String string2, List<Document> list, boolean bl) {
        this(string, string2, list, bl, null);
    }

    public Insert(String string, String string2, List<Document> list, boolean bl, VersionRange versionRange) {
        super(string, string2, ReadPreference.PRIMARY, versionRange);
        this.myDocuments = new ArrayList<Document>(list);
        this.myContinueOnError = bl;
        this.myDocumentsSize = -1;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Insert insert = (Insert)object;
            bl = super.equals(object) && this.myContinueOnError == insert.myContinueOnError && this.myDocuments.equals(insert.myDocuments);
        }
        return bl;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.myDocuments);
    }

    @Override
    public String getOperationName() {
        return Operation.INSERT.name();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myContinueOnError ? 1 : 3);
        n = 31 * n + this.myDocuments.hashCode();
        return n;
    }

    public boolean isContinueOnError() {
        return this.myContinueOnError;
    }

    @Override
    public int size() {
        int n = 22;
        n += StringEncoder.utf8Size(this.myDatabaseName);
        n += StringEncoder.utf8Size(this.myCollectionName);
        for (Document document : this.myDocuments) {
            n = (int)((long)n + document.size());
        }
        return n;
    }

    public String toString() {
        return "Insert [myContinueOnError=" + this.myContinueOnError + ", myDocuments=" + this.myDocuments + "]";
    }

    @Override
    public void validateSize(int n) throws DocumentToLargeException {
        if (this.myDocumentsSize < 0) {
            long l = 0L;
            for (Document document : this.myDocuments) {
                l += document.size();
            }
            this.myDocumentsSize = (int)l;
        }
        if (n < this.myDocumentsSize) {
            throw new DocumentToLargeException(this.myDocumentsSize, n, this.myDocuments.get(0));
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        for (Document document : this.myDocuments) {
            n3 = (int)((long)n3 + document.size());
        }
        this.writeHeader(bsonOutputStream, n, 0, Operation.INSERT, n3);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        for (Document document : this.myDocuments) {
            bsonOutputStream.writeDocument(document);
        }
    }

    @Override
    public void write(int n, BufferingBsonOutputStream bufferingBsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        long l = this.writeHeader(bufferingBsonOutputStream, n, 0, Operation.INSERT);
        bufferingBsonOutputStream.writeInt(n2);
        bufferingBsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        for (Document document : this.myDocuments) {
            bufferingBsonOutputStream.writeDocument(document);
        }
        this.finishHeader(bufferingBsonOutputStream, l);
        bufferingBsonOutputStream.flushBuffer();
    }

    private int computeFlags() {
        int n = 0;
        if (this.myContinueOnError) {
            ++n;
        }
        return n;
    }
}

