/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;
import java.util.Arrays;

public class KillCursors
extends AbstractMessage {
    private final long[] myCursorIds;

    public KillCursors(BsonInputStream bsonInputStream) throws IOException {
        this.init(".");
        bsonInputStream.readInt();
        int n = bsonInputStream.readInt();
        this.myCursorIds = new long[n];
        for (int i = 0; i < n; ++i) {
            this.myCursorIds[i] = bsonInputStream.readLong();
        }
    }

    public KillCursors(long[] lArray, ReadPreference readPreference) {
        super("", "", readPreference);
        this.myCursorIds = Arrays.copyOf(lArray, lArray.length);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            KillCursors killCursors = (KillCursors)object;
            bl = Arrays.equals(this.myCursorIds, killCursors.myCursorIds);
        }
        return bl;
    }

    public long[] getCursorIds() {
        return Arrays.copyOf(this.myCursorIds, this.myCursorIds.length);
    }

    @Override
    public String getOperationName() {
        return Operation.KILL_CURSORS.name();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + Arrays.hashCode(this.myCursorIds);
        return n;
    }

    @Override
    public int size() {
        int n = 24;
        return n += 8 * this.myCursorIds.length;
    }

    @Override
    public void validateSize(int n) throws DocumentToLargeException {
        if (n < this.myCursorIds.length * 8) {
            throw new DocumentToLargeException(this.myCursorIds.length * 8, n, null);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = 16;
        n2 += 4;
        n2 += 4;
        this.writeHeader(bsonOutputStream, n, 0, Operation.KILL_CURSORS, n2 += 8 * this.myCursorIds.length);
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeInt(this.myCursorIds.length);
        for (long l : this.myCursorIds) {
            bsonOutputStream.writeLong(l);
        }
    }

    @Override
    public void write(int n, BufferingBsonOutputStream bufferingBsonOutputStream) throws IOException {
        long l = this.writeHeader(bufferingBsonOutputStream, n, 0, Operation.KILL_CURSORS);
        bufferingBsonOutputStream.writeInt(0);
        bufferingBsonOutputStream.writeInt(this.myCursorIds.length);
        for (long l2 : this.myCursorIds) {
            bufferingBsonOutputStream.writeLong(l2);
        }
        this.finishHeader(bufferingBsonOutputStream, l);
        bufferingBsonOutputStream.flushBuffer();
    }
}

