/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.ReplyCallback;

public class PendingMessage {
    private Message myMessage;
    private int myMessageId;
    private ReplyCallback myReplyCallback;
    private long myTimestamp;

    public PendingMessage() {
        this(0, null, null);
    }

    public PendingMessage(int n, Message message) {
        this(n, message, null);
    }

    public PendingMessage(int n, Message message, ReplyCallback replyCallback) {
        this.myMessageId = n;
        this.myMessage = message;
        this.myReplyCallback = replyCallback;
    }

    public void clear() {
        this.myTimestamp = 0L;
        this.myMessageId = 0;
        this.myMessage = null;
        this.myReplyCallback = null;
    }

    public Message getMessage() {
        return this.myMessage;
    }

    public int getMessageId() {
        return this.myMessageId;
    }

    public ReplyCallback getReplyCallback() {
        return this.myReplyCallback;
    }

    public long latency() {
        long l = this.myTimestamp;
        if (l == 0L) {
            return 0L;
        }
        return System.nanoTime() - l;
    }

    public void set(int n, Message message, ReplyCallback replyCallback) {
        this.myMessageId = n;
        this.myMessage = message;
        this.myReplyCallback = replyCallback;
        this.myTimestamp = System.nanoTime();
    }

    public void set(PendingMessage pendingMessage) {
        this.myMessageId = pendingMessage.getMessageId();
        this.myMessage = pendingMessage.getMessage();
        this.myReplyCallback = pendingMessage.getReplyCallback();
        this.myTimestamp = pendingMessage.myTimestamp;
    }

    public void timestampNow() {
        this.myTimestamp = System.nanoTime();
    }
}

