/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.VisitorAdapter;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.GeospatialOperator;
import com.allanbank.mongodb.builder.MiscellaneousOperator;
import com.allanbank.mongodb.client.VersionRange;

public class QueryVersionVisitor
extends VisitorAdapter {
    private Version myMaximumServerVersion;
    private Version myRequiredServerVersion = null;

    public static VersionRange version(Document document) {
        QueryVersionVisitor queryVersionVisitor = new QueryVersionVisitor();
        if (document != null) {
            document.accept(queryVersionVisitor);
        }
        return VersionRange.range(queryVersionVisitor.getRequiredServerVersion(), queryVersionVisitor.getMaximumServerVersion());
    }

    public Version getMaximumServerVersion() {
        return this.myMaximumServerVersion;
    }

    public Version getRequiredServerVersion() {
        return this.myRequiredServerVersion;
    }

    @Override
    protected void visitName(String string) {
        if (GeospatialOperator.GEO_WITHIN.getToken().equals(string)) {
            this.myRequiredServerVersion = Version.later(this.myRequiredServerVersion, GeospatialOperator.GEO_WITHIN.getVersion());
        } else if (GeospatialOperator.INTERSECT.getToken().equals(string)) {
            this.myRequiredServerVersion = Version.later(this.myRequiredServerVersion, GeospatialOperator.INTERSECT.getVersion());
        } else if ("$polygon".equals(string)) {
            this.myRequiredServerVersion = Version.later(this.myRequiredServerVersion, GeospatialOperator.POLYGON_VERSION);
        } else if ("$maxTimeMS".equals(string)) {
            this.myRequiredServerVersion = Version.later(this.myRequiredServerVersion, Find.MAX_TIMEOUT_VERSION);
        } else if (MiscellaneousOperator.COMMENT.getToken().equals(string)) {
            this.myRequiredServerVersion = Version.later(this.myRequiredServerVersion, MiscellaneousOperator.COMMENT.getVersion());
        } else if (MiscellaneousOperator.TEXT.getToken().equals(string)) {
            this.myRequiredServerVersion = Version.later(this.myRequiredServerVersion, MiscellaneousOperator.TEXT.getVersion());
        } else if ("$uniqueDocs".equals(string)) {
            this.myMaximumServerVersion = Version.earlier(this.myMaximumServerVersion, GeospatialOperator.UNIQUE_DOCS_REMOVED_VERSION);
        }
    }
}

