/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;

public class Update
extends AbstractMessage {
    public static final int MULTIUPDATE_FLAG_BIT = 2;
    public static final int UPSERT_FLAG_BIT = 1;
    private final boolean myMultiUpdate;
    private final Document myQuery;
    private final Document myUpdate;
    private final boolean myUpsert;

    public Update(BsonInputStream bsonInputStream) throws IOException {
        bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        int n = bsonInputStream.readInt();
        this.myQuery = bsonInputStream.readDocument();
        this.myUpdate = bsonInputStream.readDocument();
        this.myUpsert = (n & 1) == 1;
        this.myMultiUpdate = (n & 2) == 2;
    }

    public Update(String string, String string2, Document document, Document document2, boolean bl, boolean bl2) {
        super(string, string2, ReadPreference.PRIMARY);
        this.myQuery = document;
        this.myUpdate = document2;
        this.myMultiUpdate = bl;
        this.myUpsert = bl2;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Update update = (Update)object;
            bl = super.equals(object) && this.myMultiUpdate == update.myMultiUpdate && this.myUpsert == update.myUpsert && this.myUpdate.equals(update.myUpdate) && this.myQuery.equals(update.myQuery);
        }
        return bl;
    }

    @Override
    public String getOperationName() {
        return Operation.UPDATE.name();
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public Document getUpdate() {
        return this.myUpdate;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myMultiUpdate ? 1 : 3);
        n = 31 * n + (this.myUpsert ? 1 : 3);
        n = 31 * n + this.myUpdate.hashCode();
        n = 31 * n + this.myQuery.hashCode();
        return n;
    }

    public boolean isMultiUpdate() {
        return this.myMultiUpdate;
    }

    public boolean isUpsert() {
        return this.myUpsert;
    }

    @Override
    public int size() {
        int n = 26;
        n += StringEncoder.utf8Size(this.myDatabaseName);
        n += StringEncoder.utf8Size(this.myCollectionName);
        n = (int)((long)n + this.myQuery.size());
        n = (int)((long)n + this.myUpdate.size());
        return n;
    }

    @Override
    public void validateSize(int n) throws DocumentToLargeException {
        long l;
        long l2;
        long l3 = l2 = this.myQuery != null ? this.myQuery.size() : 0L;
        if ((long)n < l2) {
            throw new DocumentToLargeException((int)l2, n, this.myQuery);
        }
        long l4 = l = this.myUpdate != null ? this.myUpdate.size() : 0L;
        if ((long)n < l) {
            throw new DocumentToLargeException((int)l, n, this.myUpdate);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        n3 += 4;
        n3 = (int)((long)n3 + this.myQuery.size());
        n3 = (int)((long)n3 + this.myUpdate.size());
        this.writeHeader(bsonOutputStream, n, 0, Operation.UPDATE, n3);
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeDocument(this.myQuery);
        bsonOutputStream.writeDocument(this.myUpdate);
    }

    @Override
    public void write(int n, BufferingBsonOutputStream bufferingBsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        long l = this.writeHeader(bufferingBsonOutputStream, n, 0, Operation.UPDATE);
        bufferingBsonOutputStream.writeInt(0);
        bufferingBsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bufferingBsonOutputStream.writeInt(n2);
        bufferingBsonOutputStream.writeDocument(this.myQuery);
        bufferingBsonOutputStream.writeDocument(this.myUpdate);
        this.finishHeader(bufferingBsonOutputStream, l);
        bufferingBsonOutputStream.flushBuffer();
    }

    private int computeFlags() {
        int n = 0;
        if (this.myMultiUpdate) {
            n += 2;
        }
        if (this.myUpsert) {
            ++n;
        }
        return n;
    }
}

